/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.vctweaker;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import se.gory_moon.vctweaker.VCTweakerCore;
import se.gory_moon.vctweaker.fuel.FuelHandler;

public class VCTweakerContainer
extends DummyModContainer {
    public static final String MODID = "vctweaker";
    public static final String VERSION = "2.3";

    public VCTweakerContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = MODID;
        meta.name = "ViesCraft Tweaker";
        meta.version = VERSION;
        meta.credits = "Viesis - The author of ViesCraft";
        meta.authorList = Collections.singletonList("GoryMoon");
        meta.description = "A mod that modifies and fixes some things in ViesCraft";
        meta.logoFile = "/assets/vctweaker/textures/logo.png";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public Set<ArtifactVersion> getRequirements() {
        return Collections.singleton(VersionParser.parseVersionReference((String)"vc@[5.5.0,)"));
    }

    public List<ArtifactVersion> getDependencies() {
        return Arrays.asList(VersionParser.parseVersionReference((String)"vc@[5.5.0,)"), VersionParser.parseVersionReference((String)"jei"));
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent event) {
        ConfigManager.loadData((ASMDataTable)event.getASMHarvestedData());
        ConfigManager.sync((String)this.getModId(), (Config.Type)Config.Type.INSTANCE);
        FuelHandler.refreshConfigList(Configs.itemList);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public Certificate getSigningCertificate() {
        Certificate[] certificates = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            FuelHandler.refreshConfigList(Configs.itemList);
        }
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource() == null || this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    public File getSource() {
        return VCTweakerCore.modFile;
    }

    public Object getMod() {
        return this;
    }

    @Config(modid="vctweaker")
    public static class Configs {
        @Config.Comment(value={"Add JEI integration to ViesCraft"})
        @Config.RequiresMcRestart
        @Config.Name(value="Add JEI")
        public static boolean replaceJEI = true;
        @Config.Comment(value={"If the item list is a whitelist this needs to be true.", "If the item list is a blacklist this needs to be false"})
        @Config.Name(value="Is Whitelist")
        public static boolean isWhitelist = true;
        @Config.Comment(value={"If all blocks that are of wood material can be burnt in a airship.", "Can use this instead of defining everything in the list.", "It's affected by the whitelist setting"})
        @Config.Name(value="Burn Wood Material")
        public static boolean woodMaterial = true;
        @Config.Comment(value={"Make modded fuels ignore the whitelist/blacklist, still respects the ViesCraft setting about moded fuels.", "Mostly here to enable the default behaviour of the mod."})
        @Config.Name(value="Modded Ignore Lists")
        public static boolean moddedIgnoreList = true;
        @Config.Comment(value={"The list of items to either whitelist or blacklist when adding fuel to a airship.", "It still cares about ViesCraft fuel settings, to use vanilla/moded fuel or not.", "If you don't set a metadata for a item it automatically adds :* to the end, a wildcard for all metadata"})
        @Config.LangKey(value="Item List")
        @Config.Name(value="Item List")
        public static String[] itemList = new String[]{"minecraft:coal_block", "minecraft:sapling", "minecraft:stick", "minecraft:blaze_rod", "minecraft:coal", "minecraft:lava_bucket", "vc:viesoline_pellets"};
    }
}

