/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.vctweaker.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.gory_moon.vctweaker.util.Translator;

public class WorkbenchRecipeCategory
extends BlankRecipeCategory<IRecipeWrapper> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 120;
    public static final int height = 54;
    private final IDrawable background;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final IGuiHelper guiHelper;
    private final ResourceLocation location;

    public WorkbenchRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.location = new ResourceLocation("vc", "textures/gui/container_airship_workbench.png");
        this.background = guiHelper.createDrawable(this.location, 29, 16, 120, 54);
        this.localizedName = Translator.translateToLocal("gui.jei.category.workBench");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return "vc.workbench";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "ViesCraft";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.location, 25, 16, 124, 54);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 98, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }
}

