package se.gory_moon.tallgates.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.tallgates.items.ItemRegistry;
import se.gory_moon.tallgates.items.ItemTallGate;

import javax.annotation.Nullable;
import java.util.Random;

public class BlockTallGate extends BlockFenceGate implements BlockRegistry.IStateMappedBlock, BlockRegistry.ICustomItemBlock {

    public static final PropertyEnum<EnumGateHalf> HALF = PropertyEnum.func_177709_a("half", EnumGateHalf.class);

    public BlockTallGate(BlockPlanks.EnumType type) {
        super(type);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(field_176466_a, Boolean.FALSE).func_177226_a(field_176465_b, Boolean.FALSE).func_177226_a(field_176467_M, Boolean.FALSE).func_177226_a(HALF, EnumGateHalf.LOWER));
        func_149647_a(null);
        func_149711_c(2.0F);
        func_149752_b(5.0F);
        func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);

        return state.func_177229_b(field_185512_D).func_176740_k() == EnumFacing.Axis.X ? field_185542_e : field_185541_d;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == EnumGateHalf.LOWER) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());

            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a(field_176465_b, iblockstate.func_177229_b(field_176465_b));
            }
        } else {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());

            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a(field_185512_D, iblockstate.func_177229_b(field_185512_D)).func_177226_a(field_176466_a, iblockstate.func_177229_b(field_176466_a));
            }
        }

        return state;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == EnumGateHalf.UPPER ? Items.field_190931_a : ItemRegistry.TALL_GATE;
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return state.func_177229_b(HALF) == EnumGateHalf.UPPER ? ItemStack.field_190927_a: new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock(this));
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(HALF) == EnumGateHalf.LOWER)
            drops.add(new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock(this)));
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock(this));
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != EnumGateHalf.LOWER ? state : state.func_177226_a(field_185512_D, rot.func_185831_a(state.func_177229_b(field_185512_D)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a(state.func_177229_b(field_185512_D)));
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        } else {
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            return state.func_185904_a().func_76220_a() && worldIn.func_180495_p(pos).func_177230_c().func_176200_f(worldIn, pos) && worldIn.func_180495_p(pos).func_177230_c().func_176200_f(worldIn, pos.func_177984_a());
        }
    }

    @Nullable
    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        blockState = func_176221_a(blockState, worldIn, pos);
        if (blockState.func_177229_b(field_176466_a)) {
            return field_185506_k;
        } else {
            return blockState.func_177229_b(field_185512_D).func_176740_k() == EnumFacing.Axis.Z ? field_185539_B : field_185540_C;
        }
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return isOpen(combineMetadata(worldIn, pos));
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean flag = worldIn.func_175640_z(pos);
        return this.func_176223_P().func_177226_a(field_185512_D, placer.func_174811_aO()).func_177226_a(field_176466_a, flag).func_177226_a(field_176465_b, flag);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos blockpos = state.func_177229_b(HALF) == EnumGateHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState stateDown = pos.equals(blockpos) ? state : worldIn.func_180495_p(blockpos);

        if (stateDown.func_177230_c() != this) {
            return false;
        } else {
            if (stateDown.func_177229_b(field_176466_a)) {
                stateDown = stateDown.func_177226_a(field_176466_a, Boolean.FALSE);
                worldIn.func_180501_a(blockpos, stateDown, 10);
            } else {
                EnumFacing enumfacing = EnumFacing.func_176733_a((double)playerIn.field_70177_z);

                if (stateDown.func_177229_b(field_185512_D) == enumfacing.func_176734_d()) {
                    stateDown = stateDown.func_177226_a(field_185512_D, enumfacing);
                }

                stateDown = stateDown.func_177226_a(field_176466_a, Boolean.TRUE);
                worldIn.func_180501_a(blockpos, stateDown, 10);
            }

            worldIn.func_175704_b(blockpos, pos);
            worldIn.func_180498_a(playerIn, state.func_177229_b(field_176466_a) ? 1008 : 1014, pos, 0);
            return true;
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == EnumGateHalf.UPPER) {
            BlockPos posDown = pos.func_177977_b();
            IBlockState stateDown = worldIn.func_180495_p(posDown);

            if (stateDown.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                stateDown.func_189546_a(worldIn, posDown, blockIn, fromPos);
            }
        } else {
            BlockPos posUp = pos.func_177984_a();
            IBlockState stateUp = worldIn.func_180495_p(posUp);

            if (stateUp.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(posUp);

                if (stateUp.func_177229_b(field_176465_b) != flag) {
                    worldIn.func_180501_a(posUp, stateUp.func_177226_a(field_176465_b, flag), 2);
                    worldIn.func_180501_a(pos, state.func_177226_a(field_176466_a, flag), 2);
                    if (flag != state.func_177229_b(field_176466_a)) {
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_180498_a(null, flag ? 1008 : 1014, pos, 0);
                    }
                }
            }
        }
    }

    @Override
    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();

        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == EnumGateHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }

        if (state.func_177229_b(HALF) == EnumGateHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }

            worldIn.func_175698_g(blockpos1);
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? func_176223_P().func_177226_a(HALF, EnumGateHalf.UPPER).func_177226_a(field_176465_b, (meta & 1) > 0): func_176223_P().func_177226_a(field_185512_D, EnumFacing.func_176731_b(meta)).func_177226_a(field_176466_a, (meta & 4) != 0);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;

        if (state.func_177229_b(HALF) == EnumGateHalf.UPPER) {
            i |= 8;

            if (state.func_177229_b(field_176465_b))
                i |= 1;

        } else {
            i = i | (state.func_177229_b(field_185512_D)).func_176736_b();

            if (state.func_177229_b(field_176466_a))
                i |= 4;
        }

        return i;
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        int i = iblockstate.func_177230_c().func_176201_c(iblockstate);
        boolean flag = isTop(i);
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        int j = iblockstate1.func_177230_c().func_176201_c(iblockstate1);
        int k = flag ? j : i;
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177984_a());
        int l = iblockstate2.func_177230_c().func_176201_c(iblockstate2);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    private static int removeHalfBit(int meta) {
        return meta & 7;
    }

    private static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    private static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, HALF, field_185512_D, field_176466_a, field_176467_M, field_176465_b);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        state = func_176221_a(state, worldIn, pos);
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            return state.func_177229_b(field_185512_D).func_176740_k() == face.func_176746_e().func_176740_k() ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        } else {
            return BlockFaceShape.UNDEFINED;
        }
    }

    @Override
    public ItemStack getRenderedItem() {
        return new ItemStack(ItemRegistry.TALL_GATE);
    }

    @Override
    public void setStateMapper(StateMap.Builder builder) {
        builder.func_178442_a(field_176465_b).func_178442_a(field_176467_M);
    }

    public enum EnumGateHalf implements IStringSerializable {
        UPPER,
        LOWER;

        public String toString()
        {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}
