/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.tallgates.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.tallgates.blocks.BlockRegistry;
import se.gory_moon.tallgates.blocks.BlockTallGate;
import se.gory_moon.tallgates.items.ItemRegistry;

public class ItemTallGate
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    private static Block[] GATE_BLOCKS = new Block[]{BlockRegistry.OAK_TALL_GATE, BlockRegistry.SPRUCE_TALL_GATE, BlockRegistry.BIRCH_TALL_GATE, BlockRegistry.JUNGLE_TALL_GATE, BlockRegistry.DARK_OAK_TALL_GATE, BlockRegistry.ACACIA_TALL_GATE};

    public ItemTallGate() {
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.setHasSubtypes(true);
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            for (int i = 0; i < GATE_BLOCKS.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.getMetadata() >= GATE_BLOCKS.length) {
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        }
        return super.getItemStackDisplayName(stack);
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getMetadata() >= GATE_BLOCKS.length) {
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        }
        return "item." + GATE_BLOCKS[stack.getMetadata()].getRegistryName().getResourcePath();
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (int i = 0; i < GATE_BLOCKS.length; ++i) {
            models.put(i, new ResourceLocation("tallgates", GATE_BLOCKS[i].getRegistryName().getResourcePath()));
        }
        return models;
    }

    public static Block getBlockFromMeta(int meta) {
        if (meta >= 0 && meta < GATE_BLOCKS.length) {
            return GATE_BLOCKS[meta];
        }
        return GATE_BLOCKS[0];
    }

    public static int getMetaFromBlock(Block block) {
        for (int i = 0; i < GATE_BLOCKS.length; ++i) {
            if (block != GATE_BLOCKS[i]) continue;
            return i;
        }
        return 0;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState blockState = worldIn.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!block.isReplaceable((IBlockAccess)worldIn, pos)) {
            pos = pos.offset(facing);
        }
        Block gateBlock = ItemTallGate.getBlockFromMeta(player.getHeldItem(hand).getMetadata());
        if (player.canPlayerEdit(pos, facing, player.getHeldItem(hand)) && gateBlock.canPlaceBlockAt(worldIn, pos)) {
            ItemTallGate.placeGate(worldIn, pos, player.getHorizontalFacing(), gateBlock);
            SoundType soundtype = gateBlock.getSoundType();
            worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            player.getHeldItem(hand).shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void placeGate(World worldIn, BlockPos pos, EnumFacing facing, Block door) {
        BlockPos blockpos = pos.up();
        boolean flag = worldIn.isBlockPowered(pos) || worldIn.isBlockPowered(blockpos);
        IBlockState iblockstate = door.getDefaultState().withProperty((IProperty)BlockTallGate.FACING, (Comparable)facing).withProperty((IProperty)BlockTallGate.POWERED, (Comparable)Boolean.valueOf(flag)).withProperty((IProperty)BlockTallGate.OPEN, (Comparable)Boolean.valueOf(flag));
        worldIn.setBlockState(pos, iblockstate.withProperty(BlockTallGate.HALF, (Comparable)((Object)BlockTallGate.EnumGateHalf.LOWER)), 2);
        worldIn.setBlockState(blockpos, iblockstate.withProperty(BlockTallGate.HALF, (Comparable)((Object)BlockTallGate.EnumGateHalf.UPPER)), 2);
        worldIn.notifyNeighborsOfStateChange(pos, door, false);
        worldIn.notifyNeighborsOfStateChange(blockpos, door, false);
    }
}

