/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.tallgates.blocks;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.gory_moon.tallgates.TallGatesMod;
import se.gory_moon.tallgates.blocks.BlockTallGate;

@Mod.EventBusSubscriber
public class BlockRegistry {
    public static final Block OAK_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.OAK);
    public static final Block SPRUCE_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.SPRUCE);
    public static final Block BIRCH_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.BIRCH);
    public static final Block JUNGLE_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.JUNGLE);
    public static final Block DARK_OAK_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.DARK_OAK);
    public static final Block ACACIA_TALL_GATE = new BlockTallGate(BlockPlanks.EnumType.ACACIA);
    public static final Set<Block> BLOCKS = new LinkedHashSet<Block>();
    public static final List<ItemBlock> ITEM_BLOCKS = new ArrayList<ItemBlock>();

    public static void preInit() {
        try {
            for (Field field : BlockRegistry.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Block)) continue;
                Block block = (Block)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                BlockRegistry.registerBlock(name, block);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        ((Block)block.setRegistryName("tallgates", name)).setUnlocalizedName("tallgates." + name);
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : BLOCKS) {
            registry.register((IForgeRegistryEntry)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockRenderers(ModelRegistryEvent event) {
        for (Block block : BLOCKS) {
            ICustomItemBlock customItemBlock;
            ItemStack renderedItem;
            if (block instanceof IStateMappedBlock) {
                StateMap.Builder builder = new StateMap.Builder();
                ((IStateMappedBlock)block).setStateMapper(builder);
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)builder.build());
            }
            if (block instanceof ICustomItemBlock && !(renderedItem = (customItemBlock = (ICustomItemBlock)block).getRenderedItem()).isEmpty()) {
                Map<Integer, ResourceLocation> map = TallGatesMod.proxy.getItemModelMap(renderedItem.getItem());
                ModelResourceLocation model = (ModelResourceLocation)map.get(renderedItem.getMetadata());
                ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)block), (int)0, (ModelResourceLocation)model);
                continue;
            }
            ResourceLocation name = block.getRegistryName();
            ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    public static interface IStateMappedBlock {
        @SideOnly(value=Side.CLIENT)
        public void setStateMapper(StateMap.Builder var1);
    }

    public static interface ICustomItemBlock {
        @Nonnull
        default public ItemBlock getItemBlock() {
            if (Item.getItemFromBlock((Block)((Block)this)) != Items.AIR) {
                return (ItemBlock)Item.getItemFromBlock((Block)((Block)this));
            }
            return new ItemBlock((Block)this);
        }

        @SideOnly(value=Side.CLIENT)
        default public ItemStack getRenderedItem() {
            return ItemStack.EMPTY;
        }
    }
}

