/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces.sign;

import com.google.common.collect.Lists;
import gory_moon.moarsigns.client.interfaces.GuiBase;
import gory_moon.moarsigns.client.interfaces.GuiColorButton;
import gory_moon.moarsigns.client.interfaces.GuiRectangle;
import gory_moon.moarsigns.client.interfaces.sign.GuiSignTextField;
import gory_moon.moarsigns.client.interfaces.sign.GuiTextStyleButton;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonColorPicker;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonCopy;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonCopySign;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonCut;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonCutSign;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonLock;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonPaste;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonPasteSign;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonReset;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonShowHide;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonTextLocation;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonTextShadow;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonTextSize;
import gory_moon.moarsigns.client.interfaces.sign.buttons.ButtonTextStyle;
import gory_moon.moarsigns.client.interfaces.sign.buttons.GuiButton;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignUpdate;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiMoarSign
extends GuiBase {
    public static final ResourceLocation texture = new ResourceLocation("moarsigns", "textures/gui/sign_base.png");
    private final int TEXT_EDIT_AREA = 14;
    public int selectedTextField = 0;
    public boolean showColors = false;
    public boolean showTextStyles;
    public GuiRectangle textStyleRect;
    public int textStyleMaxWidth = 0;
    public int textStyleDialogPos = 0;
    public int colorsDialogPos = 0;
    public GuiRectangle textColorsRect;
    public List<GuiButton> buttons = new ArrayList<GuiButton>();
    public GuiSignTextField[] guiTextFields = new GuiSignTextField[4];
    public int[] rowSizes = new int[4];
    public int[] rowLocations = new int[4];
    public boolean[] visibleRows = new boolean[4];
    public boolean[] shadowRows = new boolean[4];
    public ArrayList<GuiButton> textButtons = new ArrayList();
    public ButtonReset buttonErase;
    public ButtonColorPicker buttonColorPicker;
    public ButtonTextStyle buttonTextStyle;
    public ButtonLock buttonLock;
    int oldSelectedIndex = -1;
    private GuiColorButton[] colorButtons = new GuiColorButton[16];
    private GuiTextStyleButton[] styleButtons = new GuiTextStyleButton[6];
    private ButtonCutSign buttonCutSign;
    private ButtonCopySign buttonCopySign;
    private boolean initied = false;
    private TileEntityMoarSign entitySign;

    public GuiMoarSign(TileEntityMoarSign te) {
        this.entitySign = te;
    }

    public static ITextComponent[] getSignTextWithColor(String[] array) {
        ITextComponent[] result = new ITextComponent[array.length];
        Pattern p = Pattern.compile("([\u222b]([a-z0-9])(?=\\}))+");
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!s.equals("")) {
                Matcher m = p.matcher(s);
                while (m.find()) {
                    s = s.replace("{" + m.group(0) + "}", '\u00a7' + m.group(2));
                }
            }
            result[i] = new TextComponentString(s);
        }
        return result;
    }

    public static String[] getSignTextWithCode(ITextComponent[] array) {
        String[] result = new String[array.length];
        Pattern p = Pattern.compile("([\u00a7]([a-z0-9]))+");
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) {
                System.out.println(array[i].getUnformattedText() + ": " + array[i].getUnformattedComponentText() + ": " + array[i].getFormattedText());
                String s = array[i].getUnformattedText();
                if (!s.equals("")) {
                    Matcher m = p.matcher(s);
                    while (m.find()) {
                        s = s.replace(m.group(0), "{\u222b" + m.group(2) + "}");
                    }
                }
                result[i] = s;
                continue;
            }
            result[i] = "";
        }
        return result;
    }

    @Override
    public void initGui() {
        int i;
        super.initGui();
        this.buttonList.clear();
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.entitySign.setEditAble(false);
        String[] text = GuiMoarSign.getSignTextWithCode(this.entitySign.signText);
        this.rowSizes = Arrays.copyOf(this.entitySign.rowSizes, this.entitySign.rowSizes.length);
        this.rowLocations = Arrays.copyOf(this.entitySign.rowLocations, this.entitySign.rowLocations.length);
        this.visibleRows = Arrays.copyOf(this.entitySign.visibleRows, this.entitySign.visibleRows.length);
        this.shadowRows = Arrays.copyOf(this.entitySign.shadowRows, this.entitySign.shadowRows.length);
        int k = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int row = this.guiTop + 100 + k * 18;
            ButtonTextLocation btnText1 = new ButtonTextLocation(i2, this.guiLeft + 14 + 108, row, true);
            ButtonTextLocation btnText2 = new ButtonTextLocation(i2, this.guiLeft + 14 + 108, row + 8, false);
            ButtonTextSize btnSize1 = new ButtonTextSize(i2, this.guiLeft + 14 + 125, row, true);
            ButtonTextSize btnSize2 = new ButtonTextSize(i2, this.guiLeft + 14 + 142, row, false);
            ButtonTextShadow btnSha = new ButtonTextShadow(i2, this.guiLeft + 14 + 159, row, this.shadowRows[i2]);
            this.buttons.add(btnText1);
            this.buttons.add(btnText2);
            this.buttons.add(new ButtonShowHide(i2, this.guiLeft + 14, row, !this.visibleRows[i2]));
            this.buttons.add(btnSize1);
            this.buttons.add(btnSize2);
            this.buttons.add(btnSha);
            if (i2 > 0) {
                this.textButtons.add(btnText1);
                this.textButtons.add(btnText2);
                this.textButtons.add(btnSize1);
                this.textButtons.add(btnSize2);
                this.textButtons.add(btnSha);
            }
            this.guiTextFields[i2] = new GuiSignTextField(i2, this.fontRendererObj, this.guiLeft + 14 + 17, row, 90, 16);
            this.guiTextFields[i2].setText(text[i2] != null ? text[i2] : "");
            ++k;
        }
        if (this.selectedTextField != -1) {
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        this.textStyleRect = new GuiRectangle(this.guiLeft + 150, this.guiTop + 30, 60, 116);
        this.textColorsRect = new GuiRectangle(this.guiLeft + 150, this.guiTop + 30, 65, 65);
        int buttonBase = 18;
        this.buttons.add(new ButtonCut(this.guiLeft + buttonBase, this.guiTop + 10));
        this.buttons.add(new ButtonCopy(this.guiLeft + buttonBase + 21, this.guiTop + 10));
        this.buttons.add(new ButtonPaste(this.guiLeft + buttonBase + 42, this.guiTop + 10));
        this.buttonCutSign = new ButtonCutSign(this.guiLeft + buttonBase + 63, this.guiTop + 10);
        this.buttons.add(this.buttonCutSign);
        this.buttonCopySign = new ButtonCopySign(this.guiLeft + buttonBase + 84, this.guiTop + 10);
        this.buttons.add(this.buttonCopySign);
        this.buttons.add(new ButtonPasteSign(this.guiLeft + buttonBase + 105, this.guiTop + 10));
        this.buttonErase = new ButtonReset(this.guiLeft + buttonBase + 126, this.guiTop + 10);
        this.buttons.add(this.buttonErase);
        this.buttonColorPicker = new ButtonColorPicker(this.guiLeft + buttonBase + 147, this.guiTop + 10);
        this.buttons.add(this.buttonColorPicker);
        this.buttonTextStyle = new ButtonTextStyle(this.guiLeft + buttonBase + 168, this.guiTop + 10);
        this.buttons.add(this.buttonTextStyle);
        this.buttonLock = new ButtonLock(this.guiLeft + 181 + 14, this.guiTop + 136, 224);
        this.buttons.add(this.buttonLock);
        this.colorsDialogPos = this.buttonColorPicker.getX() + this.buttonColorPicker.getW() / 2 - this.guiLeft - 32;
        k = 0;
        int j = 0;
        for (i = 0; i < this.colorButtons.length; ++i) {
            this.colorButtons[i] = new GuiColorButton(this.guiLeft + this.colorsDialogPos + 5 + 14 * k, this.guiTop + 30 + 5 + 14 * j, 12, 12, i, -5066062, -12434878);
            if (k > 2) {
                k = 0;
                ++j;
                continue;
            }
            ++k;
        }
        for (i = 0; i < this.styleButtons.length; ++i) {
            this.styleButtons[i] = new GuiTextStyleButton(this.guiLeft + 150 + 5, this.guiTop + 30 + 5 + 18 * i, 50, 16, i);
            int width = this.fontRendererObj.getStringWidth(this.styleButtons[i].getDrawnString(this));
            if (width <= this.textStyleMaxWidth) continue;
            this.textStyleMaxWidth = width + 12;
        }
        this.textStyleDialogPos = this.buttonTextStyle.getX() + this.buttonTextStyle.getW() / 2 - this.guiLeft - (this.textStyleMaxWidth + 10) / 2;
        for (GuiTextStyleButton b : this.styleButtons) {
            b.setWidth(this.textStyleMaxWidth);
            b.setX(this.textStyleDialogPos + this.guiLeft + 5);
        }
        this.buttonList.add(new net.minecraft.client.gui.GuiButton(0, this.guiLeft + 12, this.guiTop + 174, I18n.format((String)"gui.done", (Object[])new Object[0])));
        this.update();
        this.initied = true;
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.entitySign.setEditAble(true);
        for (int i = 0; i < this.entitySign.signText.length; ++i) {
            int maxLength = Utils.getMaxLength(this.rowSizes[i]);
            String s = this.fontRendererObj.trimStringToWidth(this.entitySign.signText[i].getUnformattedText(), Math.min(this.fontRendererObj.getStringWidth(this.entitySign.signText[i].getUnformattedText()), maxLength - this.toPixelWidth(this.getStyleOffset(i))));
            this.entitySign.signText[i] = new TextComponentString(s);
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageSignUpdate(this.entitySign));
    }

    protected void actionPerformed(net.minecraft.client.gui.GuiButton btn) {
        if (btn.enabled && btn.id == 0) {
            this.entitySign.markDirty();
            this.mc.thePlayer.closeScreen();
        }
    }

    public void updateScreen() {
        for (GuiSignTextField guiTextField : this.guiTextFields) {
            guiTextField.updateCursorCounter();
        }
    }

    protected void keyTyped(char typedChar, int key) {
        if (this.selectedTextField != -1) {
            int index = 0;
            for (GuiSignTextField textField : this.guiTextFields) {
                if (textField.isFocused()) {
                    textField.textboxKeyTyped(typedChar, key);
                }
                this.entitySign.signText[index++] = new TextComponentString(textField.getText());
            }
        }
        this.update();
        if (key == 200) {
            this.guiTextFields[this.selectedTextField].setFocused(false);
            this.selectedTextField = this.selectedTextField - 1 < 0 ? 3 : this.selectedTextField - 1;
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        if (key == 208 || key == 28 || key == 156) {
            this.guiTextFields[this.selectedTextField].setFocused(false);
            this.selectedTextField = this.selectedTextField + 1 > 3 ? 0 : this.selectedTextField + 1;
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        if (key == 1) {
            this.entitySign.markDirty();
            this.mc.thePlayer.closeScreen();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawScreen(int x, int y, float par3) {
        this.drawDefaultBackground();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMoarSign.bindTexture(texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        super.drawScreen(x, y, par3);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMoarSign.bindTexture(texture);
        if (this.initied) {
            for (GuiButton button : this.buttons) {
                button.drawButton(this, x, y);
            }
        }
        this.drawVerticalLine(this.guiLeft + 14 + 189, this.guiTop + 126, this.guiTop + 136, Colors.BLACK.getARGB());
        this.drawVerticalLine(this.guiLeft + 14 + 189, this.guiTop + 150, this.guiTop + 162, Colors.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 189, this.guiTop + 126, Colors.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 181, this.guiTop + 144, Colors.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 189, this.guiTop + 162, Colors.BLACK.getARGB());
        for (GuiSignTextField textField : this.guiTextFields) {
            textField.drawTextBox();
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)this.guiLeft + 112.0f), (float)((float)this.guiTop - 27.0f), (float)40.0f);
        float scale = 93.75f;
        GlStateManager.scale((float)(-scale), (float)(-scale), (float)(-scale));
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.entitySign.getBlockMetadata();
        this.entitySign.showInGui = true;
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)0.0f, (float)-0.8f, (float)0.0f);
        TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        GlStateManager.popMatrix();
        this.entitySign.showInGui = false;
        if (this.showColors) {
            void var8_17;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)90.0f);
            GlStateManager.disableLighting();
            GuiMoarSign.bindTexture(texture);
            this.drawTexturedModalRect(this.guiLeft + this.colorsDialogPos, this.guiTop + 30, 0, 0, 60, 60);
            this.drawTexturedModalRect(this.guiLeft + this.colorsDialogPos + 59, this.guiTop + 30, 219, 0, 5, 60);
            this.drawTexturedModalRect(this.guiLeft + this.colorsDialogPos, this.guiTop + 89, 0, 195, 35, 5);
            this.drawTexturedModalRect(this.guiLeft + this.colorsDialogPos + 34, this.guiTop + 89, 194, 195, 30, 5);
            GuiColorButton[] guiColorButtonArray = this.colorButtons;
            int textField = guiColorButtonArray.length;
            boolean bl = false;
            while (var8_17 < textField) {
                GuiColorButton color = guiColorButtonArray[var8_17];
                color.draw(this, x, y);
                ++var8_17;
            }
            int k1 = 0;
            int j = 0;
            for (Colors colors : Colors.values()) {
                GuiMoarSign.drawRect((int)(this.guiLeft + this.colorsDialogPos + 6 + k1 * 14), (int)(this.guiTop + 32 + 4 + j * 14), (int)(this.guiLeft + this.colorsDialogPos + 16 + k1 * 14), (int)(this.guiTop + 32 + 14 + j * 14), (int)colors.getARGB());
                if (k1 > 2) {
                    k1 = 0;
                    ++j;
                    continue;
                }
                ++k1;
            }
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
            for (GuiColorButton guiColorButton : this.colorButtons) {
                if (!guiColorButton.inRect(x, y)) continue;
                Localization.GUI.COLORS s = Localization.GUI.COLORS.values()[guiColorButton.getId(this, x, y)];
                this.drawHoveringText(Lists.asList((Object)s.translate(), (Object[])new String[0]), x, y, this.fontRendererObj);
            }
        }
        if (this.showTextStyles) {
            void var8_23;
            void var8_21;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)91.0f);
            GlStateManager.disableLighting();
            GuiMoarSign.bindTexture(texture);
            GuiMoarSign.drawRect((int)(this.guiLeft + this.textStyleDialogPos + 5), (int)(this.guiTop + 35), (int)(this.guiLeft + this.textStyleDialogPos + 5 + this.textStyleMaxWidth), (int)(this.guiTop + 111 + 30), (int)-3750202);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.guiLeft + this.textStyleDialogPos, this.guiTop + 30, 0, 0, 5, 111);
            this.drawTexturedModalRect(this.guiLeft + this.textStyleDialogPos + 5, this.guiTop + 30, 5, 0, this.textStyleMaxWidth, 5);
            this.drawTexturedModalRect(this.guiLeft + this.textStyleDialogPos + 5 + this.textStyleMaxWidth, this.guiTop + 30, 219, 0, 5, 111);
            this.drawTexturedModalRect(this.guiLeft + this.textStyleDialogPos, this.guiTop + 141, 0, 195, this.textStyleMaxWidth + 5, 5);
            this.drawTexturedModalRect(this.guiLeft + this.textStyleDialogPos + 5 + this.textStyleMaxWidth, this.guiTop + 141, 219, 195, 5, 5);
            this.zLevel += 100.0f;
            GuiTextStyleButton[] guiTextStyleButtonArray = this.styleButtons;
            int j = guiTextStyleButtonArray.length;
            boolean bl = false;
            while (var8_21 < j) {
                GuiTextStyleButton button = guiTextStyleButtonArray[var8_21];
                button.draw(this, x, y);
                ++var8_21;
            }
            this.zLevel -= 100.0f;
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
            guiTextStyleButtonArray = this.styleButtons;
            j = guiTextStyleButtonArray.length;
            boolean bl2 = false;
            while (var8_23 < j) {
                GuiTextStyleButton button = guiTextStyleButtonArray[var8_23];
                if (button.inRect(x, y)) {
                    this.drawHoveringText(Arrays.asList(button.getName().split("\n")), x, y, this.fontRendererObj);
                }
                ++var8_23;
            }
        }
        if (this.initied) {
            for (GuiButton button : this.buttons) {
                button.hoverText(this, x, y);
            }
        }
    }

    protected void mouseClicked(int x, int y, int b) throws IOException {
        super.mouseClicked(x, y, b);
        if (b == 0) {
            int n;
            boolean noTextFieldClick = false;
            if (this.showColors) {
                GuiColorButton[] guiColorButtonArray = this.colorButtons;
                n = guiColorButtonArray.length;
                for (int i = 0; i < n; ++i) {
                    GuiColorButton button = guiColorButtonArray[i];
                    int id = button.getId(this, x, y);
                    if (id == -1) continue;
                    this.showColors = false;
                    this.overlay = null;
                    this.guiTextFields[this.selectedTextField].setFocused(true);
                    this.guiTextFields[this.selectedTextField].writeText("{\u222b" + Integer.toHexString(Colors.values()[id].getNumber()) + "}");
                    this.update();
                    this.buttonColorPicker.onClick(this, x, y);
                    this.buttonColorPicker.playClickSound(this);
                    return;
                }
            }
            if (this.showTextStyles) {
                GuiTextStyleButton[] id = this.styleButtons;
                int n2 = id.length;
                for (n = 0; n < n2; ++n) {
                    GuiTextStyleButton button = id[n];
                    if (!button.inRect(x, y)) continue;
                    this.showTextStyles = false;
                    this.overlay = null;
                    this.guiTextFields[this.selectedTextField].setFocused(true);
                    this.guiTextFields[this.selectedTextField].writeText("{\u222b" + button.getStyleChar() + "}");
                    this.update();
                    this.buttonTextStyle.onClick(this, x, y);
                    this.buttonTextStyle.playClickSound(this);
                    return;
                }
            }
            for (GuiButton button : this.buttons) {
                if (button.isDisabled || !button.onClick(this, x, y)) continue;
                noTextFieldClick = true;
                this.update();
                if (this.selectedTextField == -1) continue;
                this.guiTextFields[this.selectedTextField].setFocused(true);
            }
            if (!noTextFieldClick) {
                for (GuiSignTextField guiTextField : this.guiTextFields) {
                    guiTextField.mouseClicked(x, y, b);
                }
                boolean newSet = false;
                for (int i = 0; i < this.guiTextFields.length; ++i) {
                    if (!this.guiTextFields[i].isFocused()) continue;
                    this.selectedTextField = i;
                    newSet = true;
                }
                if (!newSet) {
                    this.selectedTextField = -1;
                }
            }
        }
        this.update();
    }

    public void update() {
        int i;
        for (GuiButton button : this.buttons) {
            button.update(this);
        }
        String s = "";
        String[] array = new String[this.guiTextFields.length];
        if (!this.showColors && !this.showTextStyles) {
            this.overlay = null;
        }
        for (i = 0; i < this.guiTextFields.length; ++i) {
            array[i] = this.guiTextFields[i].getText();
            s = s + this.guiTextFields[i].getText();
        }
        for (i = 0; i < this.rowLocations.length; ++i) {
            int max = Utils.getMaxTextOffset(this.rowSizes[i]) - this.getStyleOffset(i);
            this.rowLocations[i] = max > this.rowLocations[i] ? this.rowLocations[i] : max;
        }
        if (!s.equals("")) {
            this.buttonCopySign.isDisabled = false;
            this.buttonCutSign.isDisabled = false;
            this.buttonErase.isDisabled = false;
        } else {
            this.buttonCopySign.isDisabled = true;
            this.buttonCutSign.isDisabled = true;
            this.buttonErase.isDisabled = true;
        }
        System.arraycopy(GuiMoarSign.getSignTextWithColor(array), 0, this.entitySign.signText, 0, this.entitySign.signText.length);
        this.entitySign.rowLocations = Arrays.copyOf(this.rowLocations, this.rowLocations.length);
        this.entitySign.visibleRows = Arrays.copyOf(this.visibleRows, this.visibleRows.length);
        this.entitySign.rowSizes = Arrays.copyOf(this.rowSizes, this.rowSizes.length);
        this.entitySign.shadowRows = Arrays.copyOf(this.shadowRows, this.shadowRows.length);
        this.entitySign.lockedChanges = this.buttonLock.getState();
        if (this.oldSelectedIndex != this.selectedTextField) {
            this.oldSelectedIndex = this.selectedTextField;
        }
    }

    public void changeTextSize(int id, int change) {
        if (id < this.rowSizes.length) {
            int rowSize = this.rowSizes[id];
            if (change > 0) {
                this.rowSizes[id] = rowSize + change <= 20 ? rowSize + change : 20;
            } else if (change < 0) {
                this.rowSizes[id] = rowSize + change > -1 ? rowSize + change : 0;
            }
        }
    }

    public void changeTextPosition(int id, int change) {
        if (id < this.rowLocations.length) {
            int rowLocation = this.rowLocations[id];
            if (change > 0) {
                int max = Utils.getMaxTextOffset(this.rowSizes[id]) - this.getStyleOffset(id);
                this.rowLocations[id] = max > rowLocation + change ? rowLocation + change : max;
            } else if (change < 0) {
                this.rowLocations[id] = rowLocation + change < 0 ? 0 : rowLocation + change;
            }
        }
    }

    public int getStyleOffset(int id) {
        return Utils.getStyleOffset(this.guiTextFields[id].getText(), this.shadowRows[id]);
    }

    public int toPixelWidth(int i) {
        return Utils.toPixelWidth(this.fontRendererObj, i);
    }
}

