package gory_moon.moarsigns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoarSignWall extends BlockMoarSign {

    public static final PropertyDirection FACING = PropertyDirection.func_177714_a("facing");

    protected static final AxisAlignedBB SIGN_EAST_AABB = new AxisAlignedBB(0.0D, 0.28125D, 0.0D, 0.125D, 0.78125D, 1.0D);
    protected static final AxisAlignedBB SIGN_WEST_AABB = new AxisAlignedBB(0.875D, 0.28125D, 0.0D, 1.0D, 0.78125D, 1.0D);
    protected static final AxisAlignedBB SIGN_SOUTH_AABB = new AxisAlignedBB(0.0D, 0.28125D, 0.0D, 1.0D, 0.78125D, 0.125D);
    protected static final AxisAlignedBB SIGN_NORTH_AABB = new AxisAlignedBB(0.0D, 0.28125D, 0.875D, 1.0D, 0.78125D, 1.0D);

    protected static final AxisAlignedBB SIGN_GROUND0_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.27125D, 1.0D, 0.125D, 0.77125D);
    protected static final AxisAlignedBB SIGN_GROUND1_AABB = new AxisAlignedBB(0.23125D, 0.0D, 0.0D, 0.73125D, 0.125D, 1.0D);
    protected static final AxisAlignedBB SIGN_GROUND2_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.23125D, 1.0D, 0.125D, 0.73125D);
    protected static final AxisAlignedBB SIGN_GROUND3_AABB = new AxisAlignedBB(0.27125D, 0.0D, 0.0D, 0.77125D, 0.125D, 1.0D);

    protected static final AxisAlignedBB SIGN_ROOF0_AABB = new AxisAlignedBB(0.0D, 0.875D, 0.23125D, 1.0D, 1.0D, 0.73125D);
    protected static final AxisAlignedBB SIGN_ROOF1_AABB = new AxisAlignedBB(0.27125D, 0.875D, 0.0D, 0.77125D, 1.0D, 1.0D);
    protected static final AxisAlignedBB SIGN_ROOF2_AABB = new AxisAlignedBB(0.0D, 0.875D, 0.27125D, 1.0D, 1.0D, 0.77125D);
    protected static final AxisAlignedBB SIGN_ROOF3_AABB = new AxisAlignedBB(0.23125D, 0.875D, 0.0D, 0.23125D, 1.0D, 1.0D);

    public BlockMoarSignWall(Material material, SoundType stepSound) {
        super(material, stepSound);
    }

    @Override
    public IBlockState func_176203_a(int meta)
    {
        return this.func_176223_P().func_177226_a(ROTATION, meta);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, ROTATION, FACING);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = func_176201_c(state);
        boolean flatSign = ((meta & 8) >> 3) == 1;
        int facing = flatSign ? (meta & 1): (meta & 7);
        return state.func_177226_a(FACING, EnumFacing.func_82600_a(facing));
    }

    @Override
    public int func_176201_c(IBlockState state)
    {
        return state.func_177229_b(ROTATION);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int l = state.func_177230_c().func_176201_c(state);

        EnumFacing side = EnumFacing.func_82600_a(l & 7);
        boolean flatSign = ((l & 8) >> 3) == 1;
        boolean groundSign;

        if (flatSign) {
            groundSign = (l & 1) == 1;
            int rotation = (l & 6) >> 1;

            if (groundSign) {
                switch (rotation) {
                    case 1:
                        return SIGN_GROUND1_AABB;
                    case 2:
                        return SIGN_GROUND2_AABB;
                    case 3:
                        return SIGN_GROUND3_AABB;
                    default:
                        return SIGN_GROUND0_AABB;
                }
            } else {
                switch (rotation) {
                    case 1:
                        return SIGN_ROOF1_AABB;
                    case 2:
                        return SIGN_ROOF2_AABB;
                    case 3:
                        return SIGN_ROOF3_AABB;
                    default:
                        return SIGN_ROOF0_AABB;
                }
            }
        } else {
            switch (side) {
                case NORTH:
                default:
                    return SIGN_NORTH_AABB;
                case SOUTH:
                    return SIGN_SOUTH_AABB;
                case WEST:
                    return SIGN_WEST_AABB;
                case EAST:
                    return SIGN_EAST_AABB;
            }
        }
    }

    @Override
    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbor) {
        boolean flag;
        int rotation = world.func_180495_p(pos).func_177229_b(ROTATION);
        EnumFacing facing = EnumFacing.func_82600_a(rotation & 7);


        boolean flatSign = ((rotation & 8) >> 3) == 1;
        boolean groundSign;

        if (flatSign) {
            groundSign = (rotation & 1) == 1;

            if (groundSign) {
                flag = !(world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a());
            } else {
                flag = !(world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a());
            }
        } else {

            flag = !(facing == EnumFacing.NORTH && world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76220_a());

            if (world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_185904_a().func_76220_a())
                flag = false;
        }

        if (flag) {
            world.func_175698_g(pos);
        }
    }
}
