/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import gory_moon.moarsigns.blocks.BlockMoarSign;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoarSignWall
extends BlockMoarSign {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing");

    public BlockMoarSignWall(Material material, boolean freeStand) {
        super(material, freeStand);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{ROTATION, FACING});
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        boolean flatSign = (meta & 8) >> 3 == 1;
        int facing = flatSign ? meta & 1 : meta & 7;
        return state.withProperty((IProperty)FACING, (Comparable)EnumFacing.getFront((int)facing));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)ROTATION);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, BlockPos pos) {
        boolean flatSign;
        IBlockState state = world.getBlockState(pos);
        int l = state.getBlock().getMetaFromState(state);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        EnumFacing side = EnumFacing.getFront((int)(l & 7));
        boolean bl = flatSign = (l & 8) >> 3 == 1;
        if (flatSign) {
            boolean groundSign = (l & 1) == 1;
            int rotation = (l & 6) >> 1;
            if (groundSign) {
                this.setBlockBounds(f2, f2, f - 0.01f, f3, f4, f1 - 0.01f);
                switch (rotation) {
                    case 1: {
                        this.setBlockBounds(f - 0.05f, f2, f2, f1 - 0.05f, f4, f3);
                        break;
                    }
                    case 2: {
                        this.setBlockBounds(f2, f2, f - 0.05f, f3, f4, f1 - 0.05f);
                        break;
                    }
                    case 3: {
                        this.setBlockBounds(f - 0.01f, f2, f2, f1 - 0.01f, f4, f3);
                    }
                }
            } else {
                this.setBlockBounds(f2, f3 - f4, f - 0.05f, f3, f3, f1 - 0.05f);
                switch (rotation) {
                    case 1: {
                        this.setBlockBounds(f - 0.01f, f3 - f4, f2, f1 - 0.01f, f3, f3);
                        break;
                    }
                    case 2: {
                        this.setBlockBounds(f2, f3 - f4, f - 0.01f, f3, f3, f1 - 0.01f);
                        break;
                    }
                    case 3: {
                        this.setBlockBounds(f - 0.05f, f3 - f4, f2, f1 - 0.05f, f3, f3);
                    }
                }
            }
        } else {
            switch (side) {
                case NORTH: {
                    this.setBlockBounds(f2, f - 0.01f, f3 - f4, f3, f1 - 0.01f, f3);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(f2, f - 0.01f, f2, f3, f1 - 0.01f, f4);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(f3 - f4, f - 0.01f, f2, f3, f1 - 0.01f, f3);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(f2, f - 0.01f, f2, f4, f1 - 0.01f, f3);
                }
            }
        }
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighbor) {
        boolean flag;
        boolean flatSign;
        int rotation = (Integer)world.getBlockState(pos).getValue((IProperty)ROTATION);
        EnumFacing facing = EnumFacing.getFront((int)(rotation & 7));
        boolean bl = flatSign = (rotation & 8) >> 3 == 1;
        if (flatSign) {
            boolean groundSign;
            boolean bl2 = groundSign = (rotation & 1) == 1;
            flag = groundSign ? !world.getBlockState(pos.down()).getBlock().getMaterial().isSolid() : !world.getBlockState(pos.up()).getBlock().getMaterial().isSolid();
        } else {
            boolean bl3 = flag = facing != EnumFacing.NORTH || !world.getBlockState(pos.south()).getBlock().getMaterial().isSolid();
            if (world.getBlockState(pos.offset(facing.getOpposite())).getBlock().getMaterial().isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            world.setBlockToAir(pos);
        }
    }
}

