package gory_moon.moarsigns.client.interfaces;

import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.interfaces.containers.ContainerPreview;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.util.Arrays;

public class GuiPreview extends GuiContainer {

    private static final ResourceLocation texture = new ResourceLocation("moarsigns", "textures/gui/sign_preview.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private boolean firstDraw;

    private TileEntityMoarSign sign;
    private float roll;
    private float yaw;
    private int scrollX;
    private int scrollY;
    private boolean isDraging;
    private boolean isSpinning = true;
    private boolean rollDown;

    public GuiPreview() {
        super(new ContainerPreview());

        field_146999_f = 226;
        field_147000_g = 140;
        this.field_146291_p = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        field_146292_n.clear();

        ContainerPreview containerPreview = (ContainerPreview) field_147002_h;
        containerPreview.itemList.clear();
        ModItems.sign.getSubItemStacks(containerPreview.itemList);
    }

    @Override
    public void func_73863_a(int x, int y, float renderPartialTicks) {
        if (!firstDraw) {
            this.currentScroll = 0.0F;
            ((ContainerPreview) field_147002_h).scrollTo(0.0F);
            firstDraw = true;
        }
        boolean buttonDown = Mouse.isButtonDown(0);

        if (!this.wasClicking && buttonDown && x >= field_147003_i + 101 && y >= field_147009_r + 8 && x < field_147003_i + 113 && y < field_147009_r + 132) {
            this.isScrolling = this.needsScrollBars();
        }

        if (!buttonDown) {
            this.isScrolling = false;
        }

        this.wasClicking = buttonDown;

        if (this.isScrolling) {

            this.currentScroll = ((float) (y - field_147009_r - 8) - 7.5F) / ((float) (117) - 15F);

            if (this.currentScroll < 0.0F) {
                this.currentScroll = 0.0F;
            }

            if (this.currentScroll > 1.0F) {
                this.currentScroll = 1.0F;
            }

            ((ContainerPreview) this.field_147002_h).scrollTo(this.currentScroll);
        }
        super.func_73863_a(x, y, renderPartialTicks);

        if (x >= field_147003_i + 115 && y >= field_147009_r + 5 && x < field_147003_i + 220 && y < field_147009_r + 135) {
            String s = Localization.GUI.PREVIEW.DRAG.translate();
            drawHoveringText(Arrays.asList(s.split("\n")), x, y, field_146289_q);
        }
    }

    @Override
    protected void func_146976_a(float renderPartialTicks, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        this.func_73729_b(field_147003_i + 101, field_147009_r + 8 + (int) ((float) (109) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        if (sign != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float) field_147003_i + 170F, (float) field_147009_r + 70F, 70.0F);

            float scale = 70;
            GL11.glScalef(-scale, scale, scale);

            GL11.glRotatef(180, 0, 0, 1);
            GL11.glRotatef(roll, 1, 0, 0);
            GL11.glRotatef(yaw, 0, 1, 0);

            TileEntityRendererDispatcher.field_147556_a.func_147549_a(sign, -0.5D, -0.75D, -0.5D, 0.0F);
            GL11.glPopMatrix();

            if (isSpinning) {
                yaw += 0.1F;
                roll %= 360.0F;

                if (rollDown) {
                    roll -= 0.01F;
                    if (roll > 5) {
                        roll -= 0.05F;
                    } else {
                        roll -= 0.01F;
                    }
                    if (roll < -5) {
                        rollDown = false;
                    }
                } else {
                    roll += 0.01F;
                    if ((roll < 15)) {
                        roll += 0.05F;
                    } else {
                        roll += 0.01F;
                    }
                    if (roll > 22) {
                        rollDown = true;
                    }

                }
            }
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (sign == null)
            field_146289_q.func_78279_b(Localization.GUI.PREVIEW.CLICK_SIGN.translate(), 120, 10, 70, Colors.LIGHTGRAY.getRGB());
    }

    private boolean needsScrollBars() {
        return ((ContainerPreview) field_147002_h).needsScrollBars();
    }

    protected void func_146984_a(Slot slot, int slotId, int button, int flag) {
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();

            sign = new TileEntityMoarSign();
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.func_77978_p());
            SignInfo info = SignRegistry.get(texture);

            sign.func_145834_a(FMLClientHandler.instance().getWorldClient());
            sign.isMetal = info.isMetal;
            sign.setBlockType(info.isMetal ? Blocks.signStandingMetal : Blocks.signStandingWood);
            IChatComponent[] components = new IChatComponent[]{null, new ChatComponentText((char) 167 + "nThis is some"), new ChatComponentText((char) 167 + "4example " + (char) 167 + "ltext"), null};
            System.arraycopy(components, 0, sign.field_145915_a, 0, sign.field_145915_a.length);
            sign.setResourceLocation(texture);
        }
    }


    public void func_146273_a(int x, int y, int button, long timeSinceClicked) {
        if (isDraging) {
            if (button == 0) {
                int x1 = x - field_147003_i;
                int y1 = y - field_147009_r;

                yaw = yaw + x1 - scrollX;
                roll = roll + y1 - scrollY;
                scrollX = x1;
                scrollY = y1;
            }
        }
        super.func_146273_a(x, y, button, timeSinceClicked);
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        if (button == 0) {
            if (x >= field_147003_i + 115 && y >= field_147009_r + 5 && x < field_147003_i + 220 && y < field_147009_r + 135) {
                int x1 = x - field_147003_i;
                int y1 = y - field_147009_r;

                scrollX = x1;
                scrollY = y1;
                isSpinning = false;
                isDraging = true;
            }
        }
        super.func_73864_a(x, y, button);
    }

    @Override
    public void func_146286_b(int x, int y, int button) {
        if (isDraging && button == 0) {
            isSpinning = true;
            isDraging = false;
        }
        super.func_146286_b(x, y, button);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();

        if (i != 0 && this.needsScrollBars()) {
            int j = (((ContainerPreview) this.field_147002_h).itemList.size() / 5) - 6;

            if (i > 0) {
                i = 1;
            }

            if (i < 0) {
                i = -1;
            }

            this.currentScroll = (float) ((double) this.currentScroll - (double) i / (double) j);

            if (this.currentScroll < 0.0F) {
                this.currentScroll = 0.0F;
            }

            if (this.currentScroll > 1.0F) {
                this.currentScroll = 1.0F;
            }

            ((ContainerPreview) this.field_147002_h).scrollTo(this.currentScroll);
        }
    }


}
