/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMoarSign
extends BlockContainer {
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);

    public BlockMoarSign(Material material, boolean freeStand) {
        super(material);
        this.func_149663_c("moarsign.sign");
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180646_a(world, pos);
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(world, pos, state, random);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, pos, state, entity);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            return signInfo.property.onRightClick(world, pos, state, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    effectRenderer.func_78873_a((EntityFX)new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, pos, state).func_174846_a(pos));
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos pos = target.func_178782_a();
        EnumFacing side = target.field_178784_b;
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        double d0 = (double)i + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double d1 = (double)j + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double d2 = (double)k + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + block.func_149665_z() - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + block.func_149669_A() + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + block.func_149706_B() - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + block.func_149693_C() + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + block.func_149704_x() - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + block.func_149753_y() + (double)f;
        }
        effectRenderer.func_78873_a(new EntityDiggingFXMoarSigns(world, d0, d1, d2, 0.0, 0.0, 0.0, pos, iblockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign)world.func_175625_s(pos);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.sign.createMoarItemStack(s, tileEntity.isMetal);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.func_176226_b(world, pos, state, 0);
        super.func_180663_b(world, pos, state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null) {
                return ret;
            }
            ret.add(ModItems.sign.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            ((TileEntityMoarSign)entity).removeNoDrop = player.field_71075_bZ.field_75098_d;
        }
        return super.removedByPlayer(world, pos, player, false);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return !this.func_181087_e(world, pos) && world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos);
    }

    public SignInfo getSignInfo(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            return SignRegistry.get(sign.texture_name);
        }
        return null;
    }
}

