package gory_moon.moarsigns.tileentites;

import com.google.gson.JsonParseException;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignMainInfo;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.*;
import net.minecraft.world.World;

public class TileEntityMoarSign extends TileEntitySign implements ITickable {

    public static final String NBT_VERSION_TAG = "nbtVersion";
    public static final String NBT_SETTINGS_TAG = "settings";
    public static final String NBT_LOCKED_CHANGES_TAG = "lockedChanges";
    public static final String NBT_METAL_TAG = "isMetal";
    public static final String NBT_TEXTURE_TAG = "texture";

    private final int NBT_VERSION = 2;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = {0, 0, 0, 0};
    public boolean[] visibleRows = {true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public boolean isMetal = false;
    public String texture_name;
    public boolean showInGui = false;
    public boolean removeNoDrop;
    private boolean isEditable = true;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;

    public TileEntityMoarSign() {
        super();
        for (int i = 0; i < 4; i++) {
            rowLocations[i] = 2 + 10 * i;
        }
    }

    public void setBlockType(Block block) {
        field_145854_h = block;
    }

    @Override
    public void func_73660_a() {
        if (field_145850_b.field_72995_K) {
            if (!textureReq) {
                textureReq = true;
                Block block = field_145850_b.func_180495_p(field_174879_c).func_177230_c();
                field_145850_b.func_175641_c(field_174879_c, block, 0, 0);
            }
            SignInfo sign = SignRegistry.get(texture_name);
            if (sign != null && sign.property != null) sign.property.onUpdate();
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a(NBT_VERSION_TAG, NBT_VERSION);

        NBTTagList settings = new NBTTagList();

        int[] loc = new int[5];
        loc[0] = 0;
        System.arraycopy(rowLocations, 0, loc, 1, 4);

        int[] size = new int[5];
        size[0] = 1;
        System.arraycopy(rowSizes, 0, size, 1, 4);

        int[] visible = new int[5];
        visible[0] = 2;
        for (int i = 0; i < 4; i++) visible[i + 1] = visibleRows[i] ? 1 : 0;

        int[] shadow = new int[5];
        shadow[0] = 3;
        for (int i = 0; i < 4; i++) shadow[i + 1] = shadowRows[i] ? 1 : 0;

        NBTTagIntArray locations = new NBTTagIntArray(loc);
        NBTTagIntArray sizes = new NBTTagIntArray(size);
        NBTTagIntArray hidden = new NBTTagIntArray(visible);
        NBTTagIntArray shadows = new NBTTagIntArray(shadow);

        settings.func_74742_a(locations);
        settings.func_74742_a(sizes);
        settings.func_74742_a(hidden);
        settings.func_74742_a(shadows);

        compound.func_74782_a(NBT_SETTINGS_TAG, settings);
        compound.func_74757_a(NBT_LOCKED_CHANGES_TAG, lockedChanges);
        compound.func_74757_a(NBT_METAL_TAG, isMetal);
        if (texture_name != null)
            compound.func_74778_a(NBT_TEXTURE_TAG, texture_name);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        ICommandSender icommandsender = new ICommandSender()
        {
            /**
             * Get the name of this object. For players this returns their username
             */
            public String func_70005_c_()
            {
                return "Sign";
            }
            /**
             * Get the formatted ChatComponent that will be used for the sender's username in chat
             */
            public IChatComponent func_145748_c_()
            {
                return new ChatComponentText(this.func_70005_c_());
            }
            /**
             * Send a chat message to the CommandSender
             */
            public void func_145747_a(IChatComponent component)
            {
            }
            /**
             * Returns {@code true} if the CommandSender is allowed to execute the command, {@code false} if not
             */
            public boolean func_70003_b(int permLevel, String commandName)
            {
                return permLevel <= 2; //Forge: Fixes  MC-75630 - Exploit with signs and command blocks
            }
            /**
             * Get the position in the world. <b>{@code null} is not allowed!</b> If you are not an entity in the world,
             * return the coordinates 0, 0, 0
             */
            public BlockPos func_180425_c()
            {
                return field_174879_c;
            }
            /**
             * Get the position vector. <b>{@code null} is not allowed!</b> If you are not an entity in the world,
             * return 0.0D, 0.0D, 0.0D
             */
            public Vec3 func_174791_d()
            {
                return new Vec3((double)field_174879_c.func_177958_n() + 0.5D, (double)field_174879_c.func_177956_o() + 0.5D, (double)field_174879_c.func_177952_p() + 0.5D);
            }
            /**
             * Get the world, if available. <b>{@code null} is not allowed!</b> If you are not an entity in the world,
             * return the overworld
             */
            public World func_130014_f_()
            {
                return field_145850_b;
            }
            /**
             * Returns the entity associated with the command sender. MAY BE NULL!
             */
            public Entity func_174793_f()
            {
                return null;
            }
            /**
             * Returns true if the command sender should be sent feedback about executed commands
             */
            public boolean func_174792_t_()
            {
                return false;
            }
            public void func_174794_a(CommandResultStats.Type type, int amount)
            {
            }
        };

        int nbtVersion = compound.func_74762_e(NBT_VERSION_TAG);

        if (nbtVersion == 1) {
            int fontSize = compound.func_74762_e("fontSize");
            int rows = Utils.getRows(fontSize);

            rowSizes = new int[]{fontSize, fontSize, fontSize, fontSize};
            visibleRows = new boolean[]{false, false, false, false};
            for (int i = 0; i < rows; i++) {
                visibleRows[i] = true;
            }

            int textOffset = compound.func_74762_e("textOffset");
            for (int i = 0; i < 4; i++) {
                int temp = Math.abs(textOffset) + rowLocations[i] - (textOffset != 0 ? 2 : 0);

                if (temp < 0) temp = 0;

                rowLocations[i] = temp;
            }


        } else if (nbtVersion == 2) {

            lockedChanges = compound.func_74767_n(NBT_LOCKED_CHANGES_TAG);

            NBTTagList settings = compound.func_150295_c(NBT_SETTINGS_TAG, 11);

            for (int i = 0; i < settings.func_74745_c(); i++) {
                int[] array = settings.func_150306_c(i);
                if (array[0] == 0) {
                    System.arraycopy(array, 1, rowLocations, 0, 4);
                } else if (array[0] == 1) {
                    System.arraycopy(array, 1, rowSizes, 0, 4);
                } else if (array[0] == 2) {
                    int[] hidden = new int[4];
                    System.arraycopy(array, 1, hidden, 0, 4);
                    for (int j = 0; j < 4; j++) visibleRows[j] = hidden[j] == 1;
                } else if (array[0] == 3) {
                    int[] shadows = new int[4];
                    System.arraycopy(array, 1, shadows, 0, 4);
                    for (int j = 0; j < 4; j++) shadowRows[j] = shadows[j] == 1;
                }

            }
        }

        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));

            try  {
                IChatComponent ichatcomponent = IChatComponent.Serializer.func_150699_a(s);

                try {
                    this.field_145915_a[i] = ChatComponentProcessor.func_179985_a(icommandsender, ichatcomponent, (Entity)null);
                } catch (CommandException var7) {
                    this.field_145915_a[i] = ichatcomponent;
                }
            } catch (JsonParseException var8) {
                this.field_145915_a[i] = new ChatComponentText(s);
            }
        }

        if (compound.func_74764_b(NBT_METAL_TAG))     isMetal = compound.func_74767_n(NBT_METAL_TAG);
        if (compound.func_74764_b(NBT_TEXTURE_TAG))   texture_name = compound.func_74779_i(NBT_TEXTURE_TAG);
        if (texture_name == null || texture_name.isEmpty()) texture_name = "oak_sign";

    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return (oldState.func_177230_c() != newSate.func_177230_c());
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom(new MessageSignMainInfo(this));
    }

    @Override
    public boolean func_145914_a() {
        return this.isEditable;
    }

    public void setEditAble(boolean state) {
        this.isEditable = state;

        if (!state) {
            playerEditing = null;
        }
    }

    @Override
    public void func_145913_a(boolean editable) {
        setEditAble(editable);
    }

    public ResourceLocation getResourceLocation() {
        return resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (!field_145850_b.field_72995_K) {
            texture_name = texture;
        } else if (resourceLocation == null) {
            texture_name = texture;
            resourceLocation = MoarSigns.instance.getResourceLocation(texture, isMetal);
        }
    }

    @Override
    public void func_145912_a(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    @Override
    public EntityPlayer func_145911_b() {
        return this.playerEditing;
    }

    @Override
    public boolean canRenderBreaking() {
        return true;
    }
}
