/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.jei.exchange;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.integration.jei.exchange.ExchangeGridHelper;
import gory_moon.moarsigns.integration.jei.exchange.ExchangeRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class MoarSignsExchangeCategory
implements IRecipeCategory {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final ICraftingGridHelper craftingGridHelper;

    public MoarSignsExchangeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("moarsigns", "textures/gui/sign_exchange_nei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 164, 118);
        this.localizedName = StatCollector.translateToLocal((String)"crafting.moarsigns.sign.exchange");
        this.craftingGridHelper = new ExchangeGridHelper(0, 1);
    }

    @Nonnull
    public String getUid() {
        return "moarsigns.exchange";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 74, 12);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 1 + x + y * 9;
                guiItemStacks.init(index, false, 2 + x * 18, 42 + y * 18);
            }
        }
        if (recipeWrapper instanceof ExchangeRecipe) {
            ExchangeRecipe wrapper = (ExchangeRecipe)recipeWrapper;
            this.craftingGridHelper.setInput(guiItemStacks, wrapper.getInputs());
            this.craftingGridHelper.setOutput(guiItemStacks, wrapper.getOutputs());
        } else {
            MoarSigns.logger.error("RecipeWrapper is not a known crafting wrapper type: {}", new Object[]{recipeWrapper});
        }
    }
}

