/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class MessageSignUpdate
implements IMessage,
IMessageHandler<MessageSignUpdate, IMessage> {
    public int x;
    public int y;
    public int z;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public String[] text = new String[]{"", "", "", ""};

    public MessageSignUpdate() {
    }

    public MessageSignUpdate(int x, int y, int z, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, String[] text) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignUpdate(TileEntityMoarSign tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.field_145915_a);
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        for (i = 0; i < 4; ++i) {
            this.rowLocations[i] = buf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.rowSizes[i] = buf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.visibleRows[i] = buf.readBoolean();
        }
        for (i = 0; i < 4; ++i) {
            this.shadowRows[i] = buf.readBoolean();
        }
        this.lockedChanges = buf.readBoolean();
        for (i = 0; i < 4; ++i) {
            byte[] line = new byte[buf.readInt()];
            buf.readBytes(line);
            this.text[i] = new String(line, Charset.forName("utf-8"));
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        for (i = 0; i < 4; ++i) {
            buf.writeInt(this.rowLocations[i]);
        }
        for (i = 0; i < 4; ++i) {
            buf.writeInt(this.rowSizes[i]);
        }
        for (i = 0; i < 4; ++i) {
            buf.writeBoolean(this.visibleRows[i]);
        }
        for (i = 0; i < 4; ++i) {
            buf.writeBoolean(this.shadowRows[i]);
        }
        buf.writeBoolean(this.lockedChanges);
        for (i = 0; i < 4; ++i) {
            byte[] bytes = this.text[i].getBytes(Charset.forName("utf-8"));
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    public IMessage onMessage(MessageSignUpdate message, MessageContext ctx) {
        TileEntity tileentity;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        player.func_143004_u();
        WorldServer worldserver = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
        if (worldserver.func_72899_e(message.x, message.y, message.z) && (tileentity = worldserver.func_147438_o(message.x, message.y, message.z)) instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileentitysign = (TileEntityMoarSign)tileentity;
            if (!tileentitysign.func_145914_a() || tileentitysign.func_145911_b() != player) {
                MoarSigns.logger.warn("Player " + player.func_70005_c_() + " just tried to change non-editable sign");
                return null;
            }
            tileentitysign.rowLocations = message.rowLocations;
            tileentitysign.rowSizes = message.rowSizes;
            tileentitysign.visibleRows = message.visibleRows;
            tileentitysign.shadowRows = message.shadowRows;
            tileentitysign.lockedChanges = message.lockedChanges;
            for (int i = 0; i < 4; ++i) {
                boolean flag = true;
                for (int j = 0; j < message.text[i].length(); ++j) {
                    if (Utils.isAllowedCharacter(message.text[i].charAt(j))) continue;
                    flag = false;
                }
                if (flag) continue;
                message.text[i] = "!?";
            }
            System.arraycopy(message.text, 0, tileentitysign.field_145915_a, 0, 4);
            tileentitysign.func_70296_d();
            worldserver.func_147471_g(message.x, message.y, message.z);
        }
        return null;
    }
}

