/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.lib.ToolBoxModes;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.PlacedCoord;
import gory_moon.moarsigns.util.RotationHandler;
import gory_moon.moarsigns.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSignToolbox
extends Item {
    public static final String SIGN_MOVING_TAG = "SignMoving";
    public static final String NBT_UNLOCALIZED_NAME = "SignUnlocalizedName";
    private IIcon[] icons = new IIcon[ToolBoxModes.values().length];

    public ItemSignToolbox() {
        this.func_77655_b("moarsigns.signtoolbox");
        this.func_77637_a(MoarSignsCreativeTab.tabMS);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < ToolBoxModes.values().length; ++i) {
            this.icons[i] = register.func_94245_a("moarsigns:toolbox/" + ToolBoxModes.values()[i].toString().toLowerCase());
        }
    }

    public IIcon func_77617_a(int itemDamage) {
        if (itemDamage > 5 && !this.isMoving(itemDamage)) {
            return null;
        }
        int mode = this.isMoving(itemDamage) ? 2 : itemDamage;
        return this.icons[mode];
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition.MovingObjectType hit;
            MovingObjectPosition movingObjectPosition = this.func_77621_a(world, player, false);
            MovingObjectPosition.MovingObjectType movingObjectType = hit = movingObjectPosition != null ? movingObjectPosition.field_72313_a : MovingObjectPosition.MovingObjectType.MISS;
            if (hit == MovingObjectPosition.MovingObjectType.MISS) {
                int mode;
                int n = mode = this.isMoving(stack.func_77960_j()) ? 2 : stack.func_77960_j();
                if (player.func_70093_af() && !this.isMoving(stack.func_77960_j())) {
                    return this.rotateModes(stack);
                }
                if (ToolBoxModes.values()[mode] == ToolBoxModes.EXCHANGE_MODE) {
                    this.doExchange(world, 0, 0, 0, player);
                } else if (ToolBoxModes.values()[mode] == ToolBoxModes.PREVIEW_MODE) {
                    this.doPreview(world, 0, 0, 0, player);
                }
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int mode = this.isMoving(stack.func_77960_j()) ? 2 : stack.func_77960_j();
            switch (ToolBoxModes.values()[mode]) {
                case EDIT_MODE: {
                    this.doEdit(world, x, y, z, player);
                    break;
                }
                case ROTATE_MODE: {
                    this.doRotate(world, x, y, z, player);
                    break;
                }
                case MOVE_MODE: {
                    return this.doMove(world, x, y, z, stack, player, side, hitX, hitY, hitZ);
                }
                case COPY_MODE: {
                    this.doCopy(world, x, y, z, stack, player);
                    break;
                }
                case EXCHANGE_MODE: {
                    this.doExchange(world, x, y, z, player);
                    return true;
                }
                case PREVIEW_MODE: {
                    this.doPreview(world, x, y, z, player);
                    return true;
                }
            }
        }
        return false;
    }

    private void doRotate(World world, int x, int y, int z, EntityPlayer player) {
        if (world.func_147439_a(x, y, z) instanceof BlockMoarSign) {
            RotationHandler.rotate((TileEntityMoarSign)world.func_147438_o(x, y, z), player.func_70093_af());
        }
    }

    private void doEdit(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity entity;
        if (world.func_147439_a(x, y, z) instanceof BlockMoarSign && (entity = world.func_147438_o(x, y, z)) instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            tileEntity.func_145913_a(true);
            tileEntity.func_145912_a(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(tileEntity, false), (EntityPlayerMP)player);
        }
    }

    private void doCopy(World world, int x, int y, int z, ItemStack stack, EntityPlayer player) {
        TileEntity tileEntity;
        NBTTagCompound signInfo = stack.func_77978_p();
        if (player.func_70093_af()) {
            TileEntity tileEntity2 = world.func_147438_o(x, y, z);
            if (tileEntity2 instanceof TileEntityMoarSign) {
                signInfo = new NBTTagCompound();
                tileEntity2.func_145841_b(signInfo);
                signInfo.func_82580_o("texture");
                signInfo.func_82580_o("isMetal");
                stack.func_77982_d(signInfo);
            }
        } else if (signInfo != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityMoarSign) {
            tileEntity.func_145839_a(signInfo);
            tileEntity.field_145851_c = x;
            tileEntity.field_145848_d = y;
            tileEntity.field_145849_e = z;
            world.func_147471_g(x, y, z);
        }
    }

    private boolean doMove(World world, int x, int y, int z, ItemStack stack, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        boolean val = true;
        NBTTagCompound signInfo = stack.func_77978_p();
        if (!this.isMoving(stack.func_77960_j())) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileEntityMoarSign = (TileEntityMoarSign)tileEntity;
                signInfo = new NBTTagCompound();
                tileEntity.func_145841_b(signInfo);
                ItemStack signStack = ModItems.sign.createMoarItemStack(tileEntityMoarSign.texture_name, tileEntityMoarSign.isMetal);
                String unlocalizedName = signStack.func_77977_a() + ".name";
                signInfo.func_74778_a(NBT_UNLOCALIZED_NAME, unlocalizedName);
                stack = this.toggleMoving(stack);
                tileEntityMoarSign.removeNoDrop = true;
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
        } else {
            String texture = signInfo.func_74779_i("texture");
            boolean isMetal = signInfo.func_74767_n("isMetal");
            ItemStack moarSignsStack = ModItems.sign.createMoarItemStack(texture, isMetal);
            moarSignsStack.func_77978_p().func_74757_a(SIGN_MOVING_TAG, true);
            val = ModItems.sign.func_77648_a(moarSignsStack, player, world, x, y, z, side, hitX, hitY, hitZ);
            if (val) {
                PlacedCoord coord = new PlacedCoord(x, y, z, side);
                coord = Utils.calculatePlaceSideCoord(coord);
                x = coord.x;
                y = coord.y;
                z = coord.z;
                signInfo.func_82580_o(NBT_UNLOCALIZED_NAME);
                TileEntityMoarSign entityMoarSign = (TileEntityMoarSign)world.func_147438_o(x, y, z);
                entityMoarSign.func_145839_a(signInfo);
                entityMoarSign.field_145851_c = x;
                entityMoarSign.field_145848_d = y;
                entityMoarSign.field_145849_e = z;
                world.func_147471_g(x, y, z);
                signInfo = null;
                stack = this.toggleMoving(stack);
            }
        }
        stack.func_77982_d(signInfo);
        return !val;
    }

    private void doExchange(World world, int x, int y, int z, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)2, (World)world, (int)x, (int)y, (int)z);
    }

    private void doPreview(World world, int x, int y, int z, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)3, (World)world, (int)x, (int)y, (int)z);
    }

    private ItemStack rotateModes(ItemStack stack) {
        int mode = stack.func_77960_j();
        mode = mode + 1 >= 6 ? 0 : mode + 1;
        stack.func_77964_b(mode);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() > 5 && !this.isMoving(stack.func_77960_j())) {
            stack.func_77964_b(0);
        }
        int mode = this.isMoving(stack.func_77960_j()) ? 2 : stack.func_77960_j();
        return super.func_77667_c(stack) + "." + ToolBoxModes.values()[mode].toString();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        String str = (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.CHANGE.translate((Object)((Object)Colors.LIGHTGRAY) + "[" + GameSettings.func_74298_c((int)gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString());
        int mode = this.isMoving(stack.func_77960_j()) ? 2 : stack.func_77960_j();
        switch (ToolBoxModes.values()[mode]) {
            case COPY_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.COPY.translate(Colors.LIGHTGRAY.toString() + "[" + GameSettings.func_74298_c((int)gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString(), Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.LIGHTGRAY.toString() + "[");
                if (stack.func_77978_p() == null) break;
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.func_77978_p());
                break;
            }
            case MOVE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.MOVE.translate(Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.GRAY.toString(), "\n" + Colors.RED.toString());
                if (stack.func_77978_p() == null) break;
                String unlocName = stack.func_77978_p().func_74779_i(NBT_UNLOCALIZED_NAME);
                String signName = StatCollector.func_74838_a((String)unlocName);
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_SIGN.translate(new String[0]) + " " + (Object)((Object)Colors.WHITE) + signName + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.func_77978_p());
                break;
            }
            case EXCHANGE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.EXCHANGE.translate("\n" + Colors.GRAY.toString());
                break;
            }
            case PREVIEW_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.PREVIEW.translate("\n" + Colors.GRAY.toString());
                break;
            }
            default: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.values()[stack.func_77960_j() + 1].translate(Colors.LIGHTGRAY.toString(), Colors.GRAY.toString());
            }
        }
        String[] strList = str.split("\n");
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = strList[i].trim();
        }
        Collections.addAll(list, strList);
    }

    private String getFormattedData(NBTTagCompound compound) {
        String s = "\n";
        for (int i = 0; i < 4; ++i) {
            s = s + (Object)((Object)Colors.WHITE) + "[" + (Object)((Object)Colors.GRAY) + compound.func_74779_i("Text" + (i + 1)) + (Object)((Object)Colors.WHITE) + "]\n";
        }
        return s;
    }

    private boolean isMoving(int itemDamage) {
        return (itemDamage & 7) == 7;
    }

    private ItemStack toggleMoving(ItemStack stack) {
        if (stack.func_77960_j() == 2) {
            stack.func_77964_b(7);
        } else if (this.isMoving(stack.func_77960_j())) {
            stack.func_77964_b(2);
        }
        return stack;
    }
}

