/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.client.interfaces.GuiBase;
import gory_moon.moarsigns.client.interfaces.GuiColor;
import gory_moon.moarsigns.client.interfaces.GuiColorButton;
import gory_moon.moarsigns.client.interfaces.GuiSignTextField;
import gory_moon.moarsigns.client.interfaces.GuiTextStyleButton;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonColorPicker;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonCopy;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonCopySign;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonCut;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonCutSign;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonLock;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonPaste;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonPasteSign;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonReset;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonShowHide;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonTextLocation;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonTextShadow;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonTextSize;
import gory_moon.moarsigns.client.interfaces.buttons.ButtonTextStyle;
import gory_moon.moarsigns.client.interfaces.buttons.GuiButton;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignUpdate;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMoarSign
extends GuiBase {
    public static final ResourceLocation texture = new ResourceLocation("moarsigns", "textures/gui/sign_base.png");
    private final int TEXT_EDIT_AREA = 14;
    public List<GuiButton> buttons = new ArrayList<GuiButton>();
    public GuiSignTextField[] guiTextFields = new GuiSignTextField[4];
    public int selectedTextField = 0;
    public boolean showColors = false;
    public boolean showTextStyles;
    public ArrayList<GuiButton> textButtons = new ArrayList();
    public ButtonReset buttonErase;
    public ButtonColorPicker buttonColorPicker;
    public ButtonTextStyle buttonTextStyle;
    public ButtonLock buttonLock;
    public int[] rowSizes = new int[4];
    public int[] rowLocations = new int[4];
    public boolean[] visibleRows = new boolean[4];
    public boolean[] shadowRows = new boolean[4];
    int oldSelectedIndex = -1;
    private GuiColorButton[] colorButtons = new GuiColorButton[16];
    private GuiTextStyleButton[] styleButtons = new GuiTextStyleButton[6];
    private ButtonCutSign buttonCutSign;
    private ButtonCopySign buttonCopySign;
    private TileEntityMoarSign entitySign;

    public GuiMoarSign(TileEntityMoarSign te) {
        this.entitySign = te;
    }

    public static String[] getSignTextWithColor(String[] array) {
        String[] result = new String[array.length];
        Pattern p = Pattern.compile("(?<=[\u222b])([a-z0-9])(?=\\})+");
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!s.equals("")) {
                Matcher m = p.matcher(s);
                while (m.find()) {
                    s = s.replace("{\u222b" + m.group(1) + "}", '\u00a7' + m.group(1));
                }
            }
            result[i] = s;
        }
        return result;
    }

    public static String[] getSignTextWithCode(String[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!s.equals("")) {
                s = s.replaceAll("(\u00a7[a-z0-9])+", "{\u222b$1}");
                s = s.replaceAll("([\u00a7)])+", "");
            }
            result[i] = s;
        }
        return result;
    }

    @Override
    public void initGui() {
        int i;
        super.initGui();
        this.buttonList.clear();
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        String[] text = GuiMoarSign.getSignTextWithCode(this.entitySign.signText);
        this.rowLocations = Arrays.copyOf(this.entitySign.rowLocations, this.entitySign.rowLocations.length);
        this.visibleRows = Arrays.copyOf(this.entitySign.visibleRows, this.entitySign.visibleRows.length);
        int k = 0;
        for (i = 0; i < this.rowSizes.length; ++i) {
            int row = this.guiTop + 100 + k * 18;
            ButtonTextLocation btnText1 = new ButtonTextLocation(i, this.guiLeft + 14 + 108, row, true);
            ButtonTextLocation btnText2 = new ButtonTextLocation(i, this.guiLeft + 14 + 108, row + 8, false);
            ButtonTextSize btnSize1 = new ButtonTextSize(i, this.guiLeft + 14 + 125, row, true);
            ButtonTextSize btnSize2 = new ButtonTextSize(i, this.guiLeft + 14 + 142, row, false);
            ButtonTextShadow btnSha = new ButtonTextShadow(i, this.guiLeft + 14 + 159, row, this.shadowRows[i]);
            this.buttons.add(btnText1);
            this.buttons.add(btnText2);
            this.buttons.add(new ButtonShowHide(i, this.guiLeft + 14, row, !this.visibleRows[i]));
            this.buttons.add(btnSize1);
            this.buttons.add(btnSize2);
            this.buttons.add(btnSha);
            if (i > 0) {
                this.textButtons.add(btnText1);
                this.textButtons.add(btnText2);
                this.textButtons.add(btnSize1);
                this.textButtons.add(btnSize2);
                this.textButtons.add(btnSha);
            }
            this.guiTextFields[i] = new GuiSignTextField(this.fontRendererObj, this.guiLeft + 14 + 17, row, 90, 16);
            this.guiTextFields[i].setText(text[i]);
            ++k;
        }
        if (this.selectedTextField != -1) {
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        k = 0;
        int j = 0;
        for (i = 0; i < this.colorButtons.length; ++i) {
            this.colorButtons[i] = new GuiColorButton(this.guiLeft + 150 + 5 + 14 * k, this.guiTop + 30 + 5 + 14 * j, 12, 12, i, -5066062, -12434878);
            if (k > 2) {
                k = 0;
                ++j;
                continue;
            }
            ++k;
        }
        for (i = 0; i < this.styleButtons.length; ++i) {
            this.styleButtons[i] = new GuiTextStyleButton(this.guiLeft + 150 + 5, this.guiTop + 30 + 5 + 18 * i, 50, 16, i);
        }
        this.buttonCutSign = new ButtonCutSign(this.guiLeft + 74, this.guiTop + 10);
        this.buttonCopySign = new ButtonCopySign(this.guiLeft + 95, this.guiTop + 10);
        this.buttonErase = new ButtonReset(this.guiLeft + 137, this.guiTop + 10);
        this.buttonColorPicker = new ButtonColorPicker(this.guiLeft + 158, this.guiTop + 10);
        this.buttonTextStyle = new ButtonTextStyle(this.guiLeft + 179, this.guiTop + 10);
        int LOCK_BASE_POS = 224;
        this.buttonLock = new ButtonLock(this.guiLeft + 14 + 181, this.guiTop + 136, LOCK_BASE_POS);
        this.buttons.add(new ButtonCut(this.guiLeft + 11, this.guiTop + 10));
        this.buttons.add(new ButtonCopy(this.guiLeft + 32, this.guiTop + 10));
        this.buttons.add(new ButtonPaste(this.guiLeft + 53, this.guiTop + 10));
        this.buttons.add(this.buttonCutSign);
        this.buttons.add(this.buttonCopySign);
        this.buttons.add(new ButtonPasteSign(this.guiLeft + 116, this.guiTop + 10));
        this.buttons.add(this.buttonErase);
        this.buttons.add(this.buttonColorPicker);
        this.buttons.add(this.buttonTextStyle);
        this.buttons.add(this.buttonLock);
        this.buttonList.add(new net.minecraft.client.gui.GuiButton(0, this.guiLeft + 12, this.guiTop + 174, I18n.format((String)"gui.done", (Object[])new Object[0])));
        this.update();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.entitySign.setEditable(true);
        for (int i = 0; i < this.entitySign.signText.length; ++i) {
            int maxLength = Utils.getMaxLength(this.rowSizes[i]);
            this.entitySign.signText[i] = this.fontRendererObj.trimStringToWidth(this.entitySign.signText[i], Math.min(this.fontRendererObj.getStringWidth(this.entitySign.signText[i]), maxLength - this.toPixelWidth(this.getStyleOffset(i))));
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageSignUpdate(this.entitySign));
    }

    protected void actionPerformed(net.minecraft.client.gui.GuiButton btn) {
        if (btn.enabled && btn.id == 0) {
            this.entitySign.markDirty();
            this.mc.thePlayer.closeScreen();
        }
    }

    public void updateScreen() {
        for (GuiSignTextField guiTextField : this.guiTextFields) {
            guiTextField.updateCursorCounter();
        }
    }

    protected void keyTyped(char typedChar, int key) {
        if (this.selectedTextField != -1) {
            int index = 0;
            for (GuiSignTextField textField : this.guiTextFields) {
                if (textField.isFocused()) {
                    textField.textboxKeyTyped(typedChar, key);
                }
                this.entitySign.signText[index++] = textField.getText();
            }
        }
        this.update();
        if (key == 200) {
            this.guiTextFields[this.selectedTextField].setFocused(false);
            this.selectedTextField = this.selectedTextField - 1 < 0 ? 3 : this.selectedTextField - 1;
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        if (key == 208 || key == 28 || key == 156) {
            this.guiTextFields[this.selectedTextField].setFocused(false);
            this.selectedTextField = this.selectedTextField + 1 > 3 ? 0 : this.selectedTextField + 1;
            this.guiTextFields[this.selectedTextField].setFocused(true);
        }
        if (key == 1) {
            this.mc.thePlayer.closeScreen();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawScreen(int x, int y, float par3) {
        int len$;
        this.drawDefaultBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMoarSign.bindTexture(texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        super.drawScreen(x, y, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMoarSign.bindTexture(texture);
        for (GuiButton button : this.buttons) {
            button.drawButton(this, x, y);
        }
        this.drawVerticalLine(this.guiLeft + 14 + 189, this.guiTop + 126, this.guiTop + 136, GuiColor.BLACK.getARGB());
        this.drawVerticalLine(this.guiLeft + 14 + 189, this.guiTop + 150, this.guiTop + 162, GuiColor.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 189, this.guiTop + 126, GuiColor.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 181, this.guiTop + 144, GuiColor.BLACK.getARGB());
        this.drawHorizontalLine(this.guiLeft + 14 + 175, this.guiLeft + 14 + 189, this.guiTop + 162, GuiColor.BLACK.getARGB());
        for (GuiSignTextField textField : this.guiTextFields) {
            textField.drawTextBox();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.guiLeft + 112.0f), (float)((float)this.guiTop - 27.0f), (float)40.0f);
        float scale = 93.75f;
        GL11.glScalef((float)(-scale), (float)(-scale), (float)(-scale));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.entitySign.getBlockMetadata();
        this.entitySign.showInGui = true;
        int k = i & 7;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.entitySign.blockMetadata = 2;
        GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
        TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        GL11.glPopMatrix();
        if (this.showColors) {
            void var9_16;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)90.0f);
            GL11.glDisable((int)2896);
            GuiMoarSign.bindTexture(texture);
            this.drawTexturedModalRect(this.guiLeft + 150, this.guiTop + 30, 0, 0, 60, 60);
            this.drawTexturedModalRect(this.guiLeft + 209, this.guiTop + 30, 219, 0, 5, 60);
            this.drawTexturedModalRect(this.guiLeft + 150, this.guiTop + 89, 0, 195, 35, 5);
            this.drawTexturedModalRect(this.guiLeft + 184, this.guiTop + 89, 194, 195, 30, 5);
            GuiColorButton[] arr$ = this.colorButtons;
            len$ = arr$.length;
            boolean bl = false;
            while (var9_16 < len$) {
                GuiColorButton color = arr$[var9_16];
                color.draw(this, x, y);
                ++var9_16;
            }
            int k1 = 0;
            int j = 0;
            for (GuiColor guiColor : GuiColor.values()) {
                GuiMoarSign.drawRect((int)(this.guiLeft + 152 + 4 + k1 * 14), (int)(this.guiTop + 32 + 4 + j * 14), (int)(this.guiLeft + 152 + 14 + k1 * 14), (int)(this.guiTop + 32 + 14 + j * 14), (int)guiColor.getARGB());
                if (k1 > 2) {
                    k1 = 0;
                    ++j;
                    continue;
                }
                ++k1;
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            for (GuiColorButton guiColorButton : this.colorButtons) {
                if (!guiColorButton.inRect(x, y)) continue;
                Localization.GUI.COLORS s = Localization.GUI.COLORS.values()[guiColorButton.getId(this, x, y)];
                this.drawHoveringText(Lists.asList((Object)s.translate(), (Object[])new String[0]), x, y, this.fontRendererObj);
            }
        }
        if (this.showTextStyles) {
            void var9_22;
            void var9_20;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)91.0f);
            GL11.glDisable((int)2896);
            GuiMoarSign.bindTexture(texture);
            this.drawTexturedModalRect(this.guiLeft + 150, this.guiTop + 30, 0, 0, 55, 111);
            this.drawTexturedModalRect(this.guiLeft + 205, this.guiTop + 30, 219, 0, 5, 111);
            this.drawTexturedModalRect(this.guiLeft + 150, this.guiTop + 141, 0, 195, 35, 5);
            this.drawTexturedModalRect(this.guiLeft + 180, this.guiTop + 141, 194, 195, 30, 5);
            this.zLevel += 100.0f;
            GuiTextStyleButton[] arr$ = this.styleButtons;
            len$ = arr$.length;
            boolean bl = false;
            while (var9_20 < len$) {
                GuiTextStyleButton button = arr$[var9_20];
                button.draw(this, x, y);
                ++var9_20;
            }
            this.zLevel -= 100.0f;
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            arr$ = this.styleButtons;
            len$ = arr$.length;
            boolean bl2 = false;
            while (var9_22 < len$) {
                GuiTextStyleButton button = arr$[var9_22];
                if (button.inRect(x, y)) {
                    this.drawHoveringText(Lists.asList((Object)button.getName(), (Object[])new String[0]), x, y, this.fontRendererObj);
                }
                ++var9_22;
            }
        }
        for (GuiButton button : this.buttons) {
            button.hoverText(this, x, y);
        }
    }

    protected void mouseClicked(int x, int y, int b) {
        super.mouseClicked(x, y, b);
        if (b == 0) {
            boolean noTextFieldClick = false;
            if (this.showColors) {
                for (GuiColorButton button : this.colorButtons) {
                    int id = button.getId(this, x, y);
                    if (id == -1) continue;
                    this.showColors = false;
                    this.guiTextFields[this.selectedTextField].setFocused(true);
                    this.guiTextFields[this.selectedTextField].writeText("{\u222b" + Integer.toHexString(GuiColor.values()[id].getNumber()) + "}");
                    this.update();
                    noTextFieldClick = true;
                    this.buttonColorPicker.onClick(this, x, y);
                }
            }
            if (this.showTextStyles) {
                GuiTextStyleButton[] arr$ = this.styleButtons;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    GuiTextStyleButton button = arr$[i$];
                    if (!button.inRect(x, y)) continue;
                    this.showTextStyles = false;
                    this.guiTextFields[this.selectedTextField].setFocused(true);
                    this.guiTextFields[this.selectedTextField].writeText("{\u222b" + button.getStyleChar(x, y) + "}");
                    this.update();
                    noTextFieldClick = true;
                    this.buttonTextStyle.onClick(this, x, y);
                }
            }
            for (GuiButton button : this.buttons) {
                if (button.isDisabled || !button.onClick(this, x, y)) continue;
                noTextFieldClick = true;
                this.update();
                if (this.selectedTextField == -1) continue;
                this.guiTextFields[this.selectedTextField].setFocused(true);
            }
            if (!noTextFieldClick) {
                for (GuiSignTextField guiTextField : this.guiTextFields) {
                    guiTextField.mouseClicked(x, y, b);
                }
                boolean newSet = false;
                for (int i = 0; i < this.guiTextFields.length; ++i) {
                    if (!this.guiTextFields[i].isFocused()) continue;
                    this.selectedTextField = i;
                    newSet = true;
                }
                if (!newSet) {
                    this.selectedTextField = -1;
                }
            }
        }
        this.update();
    }

    public void update() {
        int i;
        for (GuiButton button : this.buttons) {
            button.update(this);
        }
        String s = "";
        String[] array = new String[this.guiTextFields.length];
        for (i = 0; i < this.guiTextFields.length; ++i) {
            array[i] = this.guiTextFields[i].getText();
            s = s + this.guiTextFields[i].getText();
        }
        for (i = 0; i < this.rowLocations.length; ++i) {
            int max = Utils.getMaxTextOffset(this.rowSizes[i]) - this.getStyleOffset(i);
            this.rowLocations[i] = max > this.rowLocations[i] ? this.rowLocations[i] : max;
        }
        if (!s.equals("")) {
            this.buttonCopySign.isDisabled = false;
            this.buttonCutSign.isDisabled = false;
            this.buttonErase.isDisabled = false;
        } else {
            this.buttonCopySign.isDisabled = true;
            this.buttonCutSign.isDisabled = true;
            this.buttonErase.isDisabled = true;
        }
        this.entitySign.signText = GuiMoarSign.getSignTextWithColor(array);
        this.entitySign.rowLocations = Arrays.copyOf(this.rowLocations, this.rowLocations.length);
        this.entitySign.visibleRows = Arrays.copyOf(this.visibleRows, this.visibleRows.length);
        this.entitySign.rowSizes = Arrays.copyOf(this.rowSizes, this.rowSizes.length);
        this.entitySign.shadowRows = Arrays.copyOf(this.shadowRows, this.shadowRows.length);
        this.entitySign.lockedChanges = this.buttonLock.getState();
        if (this.oldSelectedIndex != this.selectedTextField) {
            this.oldSelectedIndex = this.selectedTextField;
        }
    }

    public void changeTextSize(int id, int change) {
        if (id < this.rowSizes.length) {
            int rowSize = this.rowSizes[id];
            if (change > 0) {
                this.rowSizes[id] = rowSize + change <= 20 ? rowSize + change : 20;
            } else if (change < 0) {
                this.rowSizes[id] = rowSize + change > -1 ? rowSize + change : 0;
            }
        }
    }

    public void changeTextPosition(int id, int change) {
        if (id < this.rowLocations.length) {
            int rowLocation = this.rowLocations[id];
            if (change > 0) {
                int max = Utils.getMaxTextOffset(this.rowSizes[id]) - this.getStyleOffset(id);
                this.rowLocations[id] = max > rowLocation + change ? rowLocation + change : max;
            } else if (change < 0) {
                this.rowLocations[id] = rowLocation + change < 0 ? 0 : rowLocation + change;
            }
        }
    }

    public int getStyleOffset(int id) {
        return Utils.getStyleOffset(this.guiTextFields[id].getText(), this.shadowRows[id]);
    }

    public int toPixelWidth(int i) {
        return Utils.toPixelWidth(this.fontRendererObj, i);
    }
}

