/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MessageSignMainInfo
implements IMessage,
IMessageHandler<MessageSignMainInfo, IMessage> {
    public int x;
    public int y;
    public int z;
    public String texture;
    public boolean isMetal;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public String[] text = new String[]{"", "", "", ""};

    public MessageSignMainInfo() {
    }

    public MessageSignMainInfo(int x, int y, int z, String texture, boolean isMetal, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, String[] text) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.texture = texture;
        this.isMetal = isMetal;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignMainInfo(TileEntityMoarSign tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.texture_name, tileEntity.isMetal, tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.field_145915_a);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        if (buf.readBoolean()) {
            int i;
            int textureLength = buf.readInt();
            this.texture = new String(buf.readBytes(textureLength).array());
            this.isMetal = buf.readBoolean();
            for (i = 0; i < 4; ++i) {
                this.rowLocations[i] = buf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.rowSizes[i] = buf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.visibleRows[i] = buf.readBoolean();
            }
            for (i = 0; i < 4; ++i) {
                this.shadowRows[i] = buf.readBoolean();
            }
            this.lockedChanges = buf.readBoolean();
            for (i = 0; i < 4; ++i) {
                int textLength = buf.readInt();
                this.text[i] = new String(buf.readBytes(textLength).array());
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.texture != null && this.rowLocations != null && this.rowSizes != null && this.visibleRows != null && this.text != null) {
            int i;
            buf.writeBoolean(true);
            buf.writeInt(this.texture.length());
            buf.writeBytes(this.texture.getBytes());
            buf.writeBoolean(this.isMetal);
            for (i = 0; i < 4; ++i) {
                buf.writeInt(this.rowLocations[i]);
            }
            for (i = 0; i < 4; ++i) {
                buf.writeInt(this.rowSizes[i]);
            }
            for (i = 0; i < 4; ++i) {
                buf.writeBoolean(this.visibleRows[i]);
            }
            for (i = 0; i < 4; ++i) {
                buf.writeBoolean(this.shadowRows[i]);
            }
            buf.writeBoolean(this.lockedChanges);
            for (i = 0; i < 4; ++i) {
                buf.writeInt(this.text[i].getBytes().length);
                buf.writeBytes(this.text[i].getBytes());
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageSignMainInfo message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        boolean flag = false;
        if (message.texture != null && message.rowLocations != null && message.rowSizes != null && message.visibleRows != null && message.shadowRows != null && message.text != null) {
            TileEntity tileEntity;
            if (world.func_72899_e(message.x, message.y, message.z) && (tileEntity = world.func_147438_o(message.x, message.y, message.z)) instanceof TileEntityMoarSign) {
                TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
                sign.isMetal = message.isMetal;
                sign.rowLocations = message.rowLocations;
                sign.rowSizes = message.rowSizes;
                sign.visibleRows = message.visibleRows;
                sign.shadowRows = message.shadowRows;
                sign.lockedChanges = message.lockedChanges;
                sign.setResourceLocation(message.texture);
                if (sign.isEditable()) {
                    System.arraycopy(message.text, 0, sign.field_145915_a, 0, 4);
                }
                flag = true;
            }
            if (!flag && FMLClientHandler.instance().getClient().field_71439_g != null) {
                MoarSigns.logger.info("Unable to locate sign at " + message.x + ", " + message.y + ", " + message.z);
                FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Unable to locate sign at " + message.x + ", " + message.y + ", " + message.z));
            }
        } else {
            MoarSigns.logger.error("An error with packages occurred");
        }
        return null;
    }
}

