/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.tileentites;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.interfaces.GuiMoarSign;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignMainInfo;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;

public class TileEntityMoarSign
extends TileEntitySign {
    private final int NBT_VERSION = 2;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public boolean isMetal = false;
    public String texture_name;
    public boolean showInGui = false;
    public boolean isRemovedByPlayerAndCreative;
    private boolean isEditable = true;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;

    public TileEntityMoarSign() {
        for (int i = 0; i < 4; ++i) {
            this.rowLocations[i] = 2 + 10 * i;
        }
    }

    public void updateEntity() {
        if (this.worldObj.isRemote) {
            SignInfo sign;
            if (!this.textureReq) {
                this.textureReq = true;
                Block block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, block, 0, 0);
            }
            if ((sign = SignRegistry.get(this.texture_name)) != null && sign.property != null) {
                sign.property.onUpdate();
            }
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("nbtVersion", 2);
        for (int i = 0; i < 4; ++i) {
            compound.setString("Text" + (i + 1), this.signText[i]);
        }
        NBTTagList settings = new NBTTagList();
        int[] loc = new int[5];
        loc[0] = 0;
        System.arraycopy(this.rowLocations, 0, loc, 1, 4);
        int[] size = new int[5];
        size[0] = 1;
        System.arraycopy(this.rowSizes, 0, size, 1, 4);
        int[] visible = new int[5];
        visible[0] = 2;
        for (int i = 0; i < 4; ++i) {
            visible[i + 1] = this.visibleRows[i] ? 1 : 0;
        }
        int[] shadow = new int[5];
        shadow[0] = 3;
        for (int i = 0; i < 4; ++i) {
            shadow[i + 1] = this.shadowRows[i] ? 1 : 0;
        }
        NBTTagIntArray locations = new NBTTagIntArray(loc);
        NBTTagIntArray sizes = new NBTTagIntArray(size);
        NBTTagIntArray hidden = new NBTTagIntArray(visible);
        NBTTagIntArray shadows = new NBTTagIntArray(shadow);
        settings.appendTag((NBTBase)locations);
        settings.appendTag((NBTBase)sizes);
        settings.appendTag((NBTBase)hidden);
        settings.appendTag((NBTBase)shadows);
        compound.setTag("settings", (NBTBase)settings);
        compound.setBoolean("lockedChanges", this.lockedChanges);
        compound.setBoolean("isMetal", this.isMetal);
        compound.setString("texture", this.texture_name);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.isEditable = false;
        super.readFromNBT(compound);
        int nbtVersion = compound.getInteger("nbtVersion");
        if (nbtVersion == 1) {
            int i;
            int fontSize = compound.getInteger("fontSize");
            int rows = Utils.getRows(fontSize);
            this.rowSizes = new int[]{fontSize, fontSize, fontSize, fontSize};
            this.visibleRows = new boolean[]{false, false, false, false};
            for (i = 0; i < rows; ++i) {
                this.visibleRows[i] = true;
            }
            for (i = 0; i < 4; ++i) {
                int maxLength = Utils.getMaxLength(fontSize) - GuiMoarSign.toPixelWidth(FMLClientHandler.instance().getClient().fontRenderer, GuiMoarSign.getStyleOffset(this.signText[i], this.shadowRows[i]));
                this.signText[i] = compound.getString("Text" + (i + 1));
                if (this.signText[i].length() > maxLength) {
                    this.signText[i] = FMLClientHandler.instance().getClient().fontRenderer.trimStringToWidth(this.signText[i], maxLength);
                }
                if (i <= rows) continue;
                this.signText[i] = "";
            }
            int textOffset = compound.getInteger("textOffset");
            for (int i2 = 0; i2 < 4; ++i2) {
                int temp = Math.abs(textOffset) + this.rowLocations[i2] - (textOffset != 0 ? 2 : 0);
                if (temp < 0) {
                    temp = 0;
                }
                this.rowLocations[i2] = temp;
            }
        } else if (nbtVersion == 2) {
            int i;
            this.lockedChanges = compound.getBoolean("lockedChanges");
            NBTTagList settings = compound.getTagList("settings", 11);
            for (i = 0; i < settings.tagCount(); ++i) {
                int j;
                int[] array = settings.func_150306_c(i);
                if (array[0] == 0) {
                    System.arraycopy(array, 1, this.rowLocations, 0, 4);
                    continue;
                }
                if (array[0] == 1) {
                    System.arraycopy(array, 1, this.rowSizes, 0, 4);
                    continue;
                }
                if (array[0] == 2) {
                    int[] hidden = new int[4];
                    System.arraycopy(array, 1, hidden, 0, 4);
                    for (j = 0; j < 4; ++j) {
                        this.visibleRows[j] = hidden[j] == 1;
                    }
                    continue;
                }
                if (array[0] != 3) continue;
                int[] shadows = new int[4];
                System.arraycopy(array, 1, shadows, 0, 4);
                for (j = 0; j < 4; ++j) {
                    this.shadowRows[j] = shadows[j] == 1;
                }
            }
            for (i = 0; i < 4; ++i) {
                this.signText[i] = compound.getString("Text" + (i + 1));
                int maxLength = Utils.getMaxLength(this.rowSizes[i]) - GuiMoarSign.toPixelWidth(FMLClientHandler.instance().getClient().fontRenderer, GuiMoarSign.getStyleOffset(this.signText[i], this.shadowRows[i]));
                if (this.signText[i].length() > maxLength) {
                    this.signText[i] = FMLClientHandler.instance().getClient().fontRenderer.trimStringToWidth(this.signText[i], maxLength);
                }
                if (this.visibleRows[i]) continue;
                this.signText[i] = "";
            }
        }
        this.isMetal = compound.getBoolean("isMetal");
        this.texture_name = compound.getString("texture");
    }

    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageSignMainInfo(this));
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEditable(boolean state) {
        this.isEditable = state;
        if (!state) {
            this.playerEditing = null;
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (!this.worldObj.isRemote) {
            this.texture_name = texture;
        } else if (this.resourceLocation == null) {
            this.texture_name = texture;
            this.resourceLocation = MoarSigns.instance.getResourceLocation(texture, this.isMetal);
        }
    }

    public void func_145912_a(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    public EntityPlayer func_145911_b() {
        return this.playerEditing;
    }
}

