/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.world.WorldServer;

public class MessageSignUpdate
implements IMessage,
IMessageHandler<MessageSignUpdate, IMessage> {
    public int x;
    public int y;
    public int z;
    public int fontSize;
    public int offset;
    public String[] text = new String[]{"", "", "", ""};

    public MessageSignUpdate() {
    }

    public MessageSignUpdate(int x, int y, int z, int fontSize, int offset, String[] text) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.fontSize = fontSize;
        this.offset = offset;
        this.text = text;
    }

    public MessageSignUpdate(TileEntityMoarSign tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.fontSize, tileEntity.textOffset, tileEntity.field_145915_a);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.fontSize = buf.readInt();
        this.offset = buf.readInt();
        for (int i = 0; i < 4; ++i) {
            int textLength = buf.readInt();
            this.text[i] = new String(buf.readBytes(textLength).array());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.fontSize);
        buf.writeInt(this.offset);
        for (int i = 0; i < 4; ++i) {
            buf.writeInt(this.text[i].length());
            buf.writeBytes(this.text[i].getBytes());
        }
    }

    public IMessage onMessage(MessageSignUpdate message, MessageContext ctx) {
        TileEntity tileentity;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        player.func_143004_u();
        WorldServer worldserver = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
        if (worldserver.func_72899_e(message.x, message.y, message.z) && (tileentity = worldserver.func_147438_o(message.x, message.y, message.z)) instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileentitysign = (TileEntityMoarSign)tileentity;
            if (!tileentitysign.func_145914_a() || tileentitysign.func_145911_b() != player) {
                MoarSigns.logger.warn("Player " + player.func_70005_c_() + " just tried to change non-editable sign");
                return null;
            }
            int maxLength = Utils.getMaxLength(message.fontSize);
            int rows = Utils.getRows(message.fontSize);
            for (int i = 0; i < 4; ++i) {
                boolean flag = true;
                message.text[i] = message.text[i].substring(0, Math.min(message.text[i].length(), maxLength));
                if (i > rows) {
                    message.text[i] = "";
                }
                for (int j = 0; j < message.text[i].length(); ++j) {
                    if (ChatAllowedCharacters.func_71566_a((char)message.text[i].charAt(j))) continue;
                    flag = false;
                }
                if (flag) continue;
                message.text[i] = "!?";
            }
            tileentitysign.fontSize = message.fontSize;
            tileentitysign.textOffset = message.offset;
            System.arraycopy(message.text, 0, tileentitysign.field_145915_a, 0, 4);
            tileentitysign.func_70296_d();
            worldserver.func_147471_g(message.x, message.y, message.z);
        }
        return null;
    }
}

