/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.tileentites;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignMainInfo;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;

public class TileEntityMoarSign
extends TileEntitySign {
    private final int NBT_VERSION = 1;
    public int lineBeingEdited = -1;
    public boolean isMetal = false;
    public String texture_name;
    public int fontSize = 0;
    public int textOffset = 0;
    public boolean isRemovedByPlayerAndCreative;
    private boolean isEditable = true;
    private int rows = 4;
    private int maxLength = 15;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;
    private int oldFontSize;

    public void updateEntity() {
        if (this.worldObj.isRemote) {
            SignInfo sign;
            if (this.fontSize != this.oldFontSize) {
                this.rows = Utils.getRows(this.fontSize);
                this.maxLength = Utils.getMaxLength(this.fontSize);
                this.oldFontSize = this.fontSize;
            }
            if (!this.textureReq) {
                this.textureReq = true;
                Block block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, block, 0, 0);
            }
            if ((sign = SignRegistry.get(this.texture_name)) != null && sign.property != null) {
                sign.property.onUpdate();
            }
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("nbtVersion", 1);
        for (int i = 0; i < 4; ++i) {
            compound.setString("Text" + (i + 1), this.signText[i]);
        }
        compound.setBoolean("isMetal", this.isMetal);
        compound.setString("texture", this.texture_name);
        compound.setInteger("fontSize", this.fontSize);
        compound.setInteger("textOffset", this.textOffset);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.isEditable = false;
        super.readFromNBT(compound);
        this.fontSize = compound.getInteger("fontSize");
        this.rows = Utils.getRows(this.fontSize);
        this.maxLength = Utils.getMaxLength(this.fontSize);
        for (int i = 0; i < 4; ++i) {
            this.signText[i] = compound.getString("Text" + (i + 1));
            if (this.signText[i].length() > this.maxLength) {
                this.signText[i] = FMLClientHandler.instance().getClient().fontRenderer.trimStringToWidth(this.signText[i], this.maxLength);
            }
            if (i <= this.rows) continue;
            this.signText[i] = "";
        }
        this.isMetal = compound.getBoolean("isMetal");
        this.texture_name = compound.getString("texture");
        this.textOffset = compound.getInteger("textOffset");
    }

    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageSignMainInfo(this, false));
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEditable(boolean state) {
        this.isEditable = state;
        if (!state) {
            this.playerEditing = null;
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (!this.worldObj.isRemote) {
            this.texture_name = texture;
        } else if (this.resourceLocation == null) {
            this.texture_name = texture;
            this.resourceLocation = MoarSigns.instance.getResourceLocation(texture, this.isMetal);
        }
    }

    public void func_145912_a(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    public EntityPlayer func_145911_b() {
        return this.playerEditing;
    }
}

