/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignMainInfo;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.maxStackSize = 16;
        this.setCreativeTab(MoarSigns.instance.tabMS);
        this.setUnlocalizedName("moarsign");
        this.hasSubtypes = true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        SignInfo info = SignRegistry.get(this.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return super.getUnlocalizedName() + ".sign.dummy";
        }
        return super.getUnlocalizedName() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + this.getTextureFromNBT(stack.getTagCompound());
    }

    public void registerIcons(IIconRegister register) {
        List<SignInfo> signRegistry = SignRegistry.getSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            String loc = info.isMetal ? "metal/" : "wood/";
            IIcon icon = register.registerIcon(info.modId.toLowerCase() + ":" + loc + (path.equals("") ? "" : path.replace("\\", "/")) + info.itemName);
            MoarSigns.icons.put((path.equals("") ? "" : path) + info.itemName, icon);
        }
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        this.getSubItemStacks(list);
    }

    public void getSubItemStacks(List list) {
        List<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            list.add(this.createMoarItemStack(path + info.itemName, info.isMetal));
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        SignInfo info = SignRegistry.get(this.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return MoarSigns.icons.get("oak_sign");
        }
        String path = info.material.path;
        return MoarSigns.icons.get((path.equals("") ? "" : path) + info.itemName);
    }

    public IIcon getIconIndex(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("SignTexture", signName.replace("\\", "/"));
        itemStack.setTagCompound(compound);
        return itemStack;
    }

    public String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.hasKey("SignTexture") ? compound.getString("SignTexture") : "";
    }

    public String getTextureFromNBT(NBTTagCompound compound) {
        String texture;
        String string = texture = compound != null && compound.hasKey("SignTexture") ? compound.getString("SignTexture") : "";
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityMoarSign tileEntity;
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            return false;
        }
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (!player.canPlayerEdit(x, y, z, side, stack) || !Blocks.signStandingWood.canPlaceBlockAt(world, x, y, z) || world.isRemote) {
            return false;
        }
        if (side == 1) {
            int rotation = MathHelper.floor_double((double)((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (stack.getItemDamage() == 0) {
                world.setBlock(x, y, z, Blocks.signStandingWood, rotation, 3);
            } else if (stack.getItemDamage() == 1) {
                world.setBlock(x, y, z, Blocks.signStandingMetal, rotation, 3);
            }
        } else if (stack.getItemDamage() == 0) {
            world.setBlock(x, y, z, Blocks.signWallWood, side, 3);
        } else if (stack.getItemDamage() == 1) {
            world.setBlock(x, y, z, Blocks.signWallMetal, side, 3);
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        if ((tileEntity = (TileEntityMoarSign)world.getTileEntity(x, y, z)) != null) {
            String texture = this.getTextureFromNBTFull(stack.getTagCompound());
            SignInfo info = SignRegistry.get(texture);
            if (info == null) {
                return false;
            }
            tileEntity.setResourceLocation(texture);
            tileEntity.isMetal = info.isMetal;
            tileEntity.func_145912_a(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignMainInfo(tileEntity, true), (EntityPlayerMP)player);
        }
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
    }
}

