/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.thermalfoundation;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.util.IntegrationException;
import gory_moon.moarsigns.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ThermalFoundationIntegration
implements ISignRegistration {
    private static final String TF_KEY = "thermalfoundation";
    private static final String PATH = "tf/";
    @GameRegistry.ObjectHolder(value="thermalfoundation:material")
    public static Item material = null;
    @GameRegistry.ObjectHolder(value="thermalfoundation:storage")
    public static Block block = null;
    @GameRegistry.ObjectHolder(value="thermalfoundation:storage_alloy")
    public static Block block2 = null;

    @Override
    public void registerSigns() throws IntegrationException {
        this.registerMetal("copper_sign", "copper", 192, 128, block, 0);
        this.registerMetal("tin_sign", "tin", 193, 129, block, 1);
        this.registerMetal("silver_sign", "silver", 194, 130, block, 2);
        this.registerMetal("lead_sign", "lead", 195, 131, block, 3);
        this.registerMetal("aluminum_sign", "aluminium", 196, 132, block, 4);
        this.registerMetal("nickel_sign", "nickel", 197, 133, block, 5);
        this.registerMetal("platinum_sign", "platinum", 198, 134, block, 6).setRarity(1);
        this.registerMetal("iridium_sign", "iridium", 199, 135, block, 7).setRarity(1);
        this.registerMetal("mana_metal_sign", "mana_metal", 200, 136, block, 8).setRarity(2);
        this.registerMetal("steel_sign", "steel", 224, 160, block2, 0);
        this.registerMetal("electrum_sign", "electrum", 225, 161, block2, 1);
        this.registerMetal("invar_sign", "invar", 226, 162, block2, 2);
        this.registerMetal("bronze_sign", "bronze", 227, 163, block2, 3);
        this.registerMetal("constantan_sign", "constantan", 228, 164, block2, 4);
        this.registerMetal("signalum_sign", "signalum", 229, 165, block2, 5).setRarity(1);
        this.registerMetal("lumium_sign", "lumium", 230, 166, block2, 6).setRarity(1);
        this.registerMetal("enderium_sign", "enderium", 231, 167, block2, 7).setRarity(2);
    }

    private SignInfo registerMetal(String name, String materialName, int nMeta, int iMeta, Block block, int bMeta) throws IntegrationException {
        return SignRegistry.register(name, null, materialName, PATH, true, new ItemStack(material, 1, nMeta), new ItemStack(material, 1, iMeta), new ItemStack(block, 1, bMeta), "moarsigns", TF_KEY).setMetal();
    }

    @Override
    @Nonnull
    public String getActivateTag() {
        return TF_KEY;
    }

    @Override
    @Nonnull
    public String getIntegrationName() {
        return Utils.getModName(TF_KEY);
    }

    @Override
    public String getModName() {
        return "Thermal Foundation";
    }
}

