package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.lib.Constants;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

import static gory_moon.moarsigns.items.ItemSignToolbox.SIGN_MOVING_TAG;

public class ItemMoarSign extends Item {

    public ItemMoarSign() {
        field_77777_bU = 16;
        func_77637_a(MoarSignsCreativeTab.tabMS);
        setRegistryName(Constants.SIGN_ITEM_KEY);
        func_77655_b("moarsigns");
        field_77787_bX = true;
    }

    public static String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
    }

    public static String getTextureFromNBT(NBTTagCompound compound) {
        String texture = getTextureFromNBTFull(compound);
        if (texture.contains("\\"))
            texture = texture.split("\\\\")[1];
        if (texture.contains("/"))
            texture = texture.split("/")[1];
        return texture;
    }

    public static SignInfo getInfo(NBTTagCompound compound) {
        String texture = getTextureFromNBTFull(compound);
        return SignRegistry.get(texture);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        SignInfo info = SignRegistry.get(getTextureFromNBTFull(stack.func_77978_p()));
        if (info == null)
            return super.func_77658_a() + ".sign.error";
        return super.func_77658_a() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + getTextureFromNBT(stack.func_77978_p());
    }


    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (func_194125_a(tab)) {
            getSubItemStacks(items);
        }
    }

    @SuppressWarnings("unchecked")
    public void getSubItemStacks(List list) {
        List<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();

        for (SignInfo info : signRegistry) {
            list.add(createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        SignInfo info = SignRegistry.get(getTextureFromNBTFull(stack.func_77978_p()));
        if (info != null) {
            return info.rarity;
        }
        return EnumRarity.COMMON;
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack(this, 1, (isMetal ? 1 : 0));
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("SignTexture", signName.replace("\\", "/"));
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            return EnumActionResult.PASS;
        } else {
            pos = pos.func_177972_a(facing);

            if (!player.func_175151_a(pos, facing, stack) || !ModBlocks.SIGN_STANDING_WOOD.func_176196_c(world, pos)) {
                return EnumActionResult.PASS;
            } else if (world.field_72995_K) {
                return EnumActionResult.PASS;
            } else {

                if (stack.func_77973_b() instanceof ItemSignToolbox) {
                    NBTTagCompound toolbox = stack.func_77978_p();
                    String texture = toolbox.func_74779_i(TileEntityMoarSign.NBT_TEXTURE_TAG);
                    boolean isMetal = toolbox.func_74767_n(TileEntityMoarSign.NBT_METAL_TAG);

                    stack = ModItems.SIGN.createMoarItemStack(texture, isMetal);
                    stack.func_77978_p().func_74757_a(SIGN_MOVING_TAG, true);
                }

                SignInfo info = getInfo(stack.func_77978_p());
                if (info == null)
                    return EnumActionResult.PASS;
                if (facing == EnumFacing.UP && !player.func_70093_af()) {
                    int rotation = MathHelper.func_76128_c((double) ((player.field_70177_z + 180.0F) * 16.0F / 360.0F) + 0.5D) & 15;
                    if (!info.isMetal)
                        world.func_180501_a(pos, ModBlocks.SIGN_STANDING_WOOD.func_176223_P().func_177226_a(BlockMoarSign.ROTATION, rotation), 3);
                    else
                        world.func_180501_a(pos, ModBlocks.SIGN_STANDING_METAL.func_176223_P().func_177226_a(BlockMoarSign.ROTATION, rotation), 3);

                } else {
                    int finalRotation = facing.func_176745_a();
                    if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                        int rotation = MathHelper.func_76128_c((double) (player.field_70177_z * 4.0F / 360.0F) + 0.5D) & 3;
                        finalRotation += (rotation << 1);
                        finalRotation += 8;
                    }
                    if (!info.isMetal)
                        world.func_180501_a(pos, ModBlocks.SIGN_WALL_WOOD.func_176223_P().func_177226_a(BlockMoarSign.ROTATION, finalRotation), 3);
                    else
                        world.func_180501_a(pos, ModBlocks.SIGN_WALL_METAL.func_176223_P().func_177226_a(BlockMoarSign.ROTATION, finalRotation), 3);
                }

                if (!player.field_71075_bZ.field_75098_d)
                    stack.func_190920_e(stack.func_190916_E()-1);
                TileEntity tileEntity = world.func_175625_s(pos);

                if (tileEntity instanceof TileEntityMoarSign && !ItemBlock.func_179224_a(world, player, pos, stack)) {
                    TileEntityMoarSign te = (TileEntityMoarSign) tileEntity;
                    String texture = getTextureFromNBTFull(stack.func_77978_p());

                    te.isMetal = info.isMetal;
                    te.func_145912_a(player);
                    te.setResourceLocation(texture);

                    boolean moving = stack.func_77978_p().func_74764_b(SIGN_MOVING_TAG) && stack.func_77978_p().func_74767_n(SIGN_MOVING_TAG);
                    PacketHandler.INSTANCE.sendTo(new MessageSignOpenGui(te, moving), (EntityPlayerMP) player);
                }

                return EnumActionResult.SUCCESS;
            }
        }
    }


    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag extraInfo) {
        SignInfo info = getInfo(stack.func_77978_p());
        if (info != null) {
            String modName = info.activateTag.equals(SignRegistry.ALWAYS_ACTIVE_TAG) ? "Minecraft" : info.activateTag;
            tooltip.add(Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate(Colors.WHITE + Utils.getModName(modName)));
            if (extraInfo.func_194127_a()) {
                tooltip.add(Localization.ITEM.SIGN.MATERIAL.translate(Colors.WHITE + info.material.materialName));
            }
        } else {
            tooltip.add(Colors.RED + Localization.ITEM.SIGN.ERROR.translate(Colors.RED.toString()));
        }
    }
}
