/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.items.ItemDebug;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemNugget;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.NuggetRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="moarsigns")
public class ModItems {
    public static final ItemMoarSign SIGN = new ItemMoarSign();
    public static final ItemDebug DEBUG = new ItemDebug();
    public static final ItemNugget NUGGET = new ItemNugget();
    public static final ItemSignToolbox SIGN_TOOLBOX = new ItemSignToolbox();
    public static boolean replaceRecipes = true;

    private static void registerRecipes(IForgeRegistry<IRecipe> registry) {
        ModItems.removeRecipesWithResult(registry, new ItemStack(Items.SIGN, 3));
        ArrayList list = new ArrayList();
        SIGN.getSubItemStacks(list);
        ItemStack generalSign = null;
        for (ItemStack stack : list) {
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            boolean isMetal = stack.getItemDamage() == 1;
            stack.setCount(3);
            if (texture.equals("oak_sign")) {
                generalSign = stack;
                continue;
            }
            SignInfo s = SignRegistry.get(texture);
            List<MaterialInfo> materials = SignRegistry.getAlternativeMaterials(s);
            MaterialInfo material = s != null ? s.material : null;
            materials.add(0, material);
            for (MaterialInfo info : materials) {
                ItemStack mat = info.material;
                if (mat == null || material == null) continue;
                if (isMetal) {
                    ModItems.handleMetalSign(registry, mat, info, stack);
                    stack.setCount(9);
                }
                ModItems.registerSignRecipe(registry, mat, info, stack, isMetal);
            }
        }
        ModContainer mc = Loader.instance().activeModContainer();
        Loader.instance().setActiveModContainer(null);
        registry.register(new ShapedOreRecipe(null, generalSign, new Object[]{true, "###", "###", " X ", Character.valueOf('#'), "plankWood", Character.valueOf('X'), "stickWood"}).setRegistryName(new ResourceLocation("sign")));
        Loader.instance().setActiveModContainer(mc);
        if (replaceRecipes) {
            ModItems.replaceRecipes(registry);
        }
    }

    private static void handleMetalSign(IForgeRegistry<IRecipe> registry, ItemStack mat, MaterialInfo material, ItemStack stack) {
        Container dummyContainer = new Container(){

            public boolean canInteractWith(EntityPlayer entityplayer) {
                return true;
            }

            public void onCraftMatrixChanged(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 2, 2);
        mat.setCount(1);
        if (mat.getItem() instanceof ItemBlock) {
            crafting.setInventorySlotContents(0, mat);
            mat = CraftingManager.findMatchingResult((InventoryCrafting)crafting, null);
        }
        ItemStack recNugget = null;
        mat.setCount(1);
        if (!material.gotNugget) {
            String key = mat.getTranslationKey();
            NuggetRegistry.NuggetInfo nuggetInfo = NuggetRegistry.getNuggetInfo(key);
            if (nuggetInfo != null) {
                nuggetInfo.needed = true;
                recNugget = new ItemStack((Item)NUGGET, 1, nuggetInfo.id);
                OreDictionary.registerOre((String)nuggetInfo.oreName, (ItemStack)recNugget.copy());
                recNugget.setCount(9);
                ResourceLocation loc1 = new ResourceLocation("moarsigns", nuggetInfo.regName);
                ResourceLocation loc2 = new ResourceLocation("moarsigns", nuggetInfo.regName + "_reverse");
                registry.register(new ShapelessOreRecipe(null, recNugget.copy(), new Object[]{mat}).setRegistryName(loc1));
                registry.register(new ShapedOreRecipe(null, mat, new Object[]{true, "xxx", "xxx", "xxx", Character.valueOf('x'), nuggetInfo.oreName}).setRegistryName(loc2));
            }
        } else if (material.materialNugget.isEmpty()) {
            crafting.setInventorySlotContents(0, mat);
            recNugget = CraftingManager.findMatchingResult((InventoryCrafting)crafting, null);
        } else {
            recNugget = material.materialNugget.copy();
        }
        if (recNugget != null) {
            ModItems.registerNuggetSign(registry, recNugget, stack, material);
        }
    }

    private static void registerNuggetSign(IForgeRegistry<IRecipe> registry, ItemStack nuggetMaterial, ItemStack stack, MaterialInfo material) {
        ItemStack result = stack.copy();
        result.setCount(1);
        nuggetMaterial.setCount(1);
        Object ingredient = nuggetMaterial;
        if (ModItems.isItem(nuggetMaterial, "item.moarsigns.diamond_nugget")) {
            ingredient = "nuggetDiamond";
        } else if (ModItems.isItem(nuggetMaterial, Items.IRON_NUGGET.getRegistryName().toString())) {
            ingredient = "nuggetIron";
        } else if (ModItems.isItem(nuggetMaterial, "item.moarsigns.emerald_nugget")) {
            ingredient = "nuggetEmerald";
        } else if (ModItems.isItem(nuggetMaterial, "item.moarsigns.lapis_nugget")) {
            ingredient = "nuggetLapis";
        } else if (ModItems.isItem(nuggetMaterial, "item.moarsigns.quartz_nugget")) {
            ingredient = "nuggetQuartz";
        }
        ResourceLocation group = new ResourceLocation("moarsigns", material.path.replace("/", "_") + material.materialName);
        ResourceLocation location = new ResourceLocation("moarsigns", "nugget_sign_" + (ingredient instanceof String ? ingredient : material.path.replaceAll("/", "_") + material.materialName));
        registry.register(new ShapedOreRecipe(group, result, new Object[]{true, "XXX", "XXX", " / ", Character.valueOf('X'), ingredient, Character.valueOf('/'), "stickWood"}).setRegistryName(location));
    }

    private static boolean isItem(ItemStack stack, @Nonnull String name) {
        return name.equals(stack.getTranslationKey());
    }

    private static void registerSignRecipe(IForgeRegistry<IRecipe> registry, ItemStack material, MaterialInfo materialInfo, ItemStack result, boolean isMetal) {
        String ingredient = "diamond".equals(materialInfo.materialName) ? "gemDiamond" : ("emerald".equals(materialInfo.materialName) ? "gemEmerald" : ("iron".equals(materialInfo.materialName) ? "ingotIron" : material));
        ResourceLocation location = new ResourceLocation("moarsigns", "sign_" + materialInfo.path.replaceAll("/", "_") + materialInfo.materialName);
        ResourceLocation group = null;
        if (isMetal) {
            group = new ResourceLocation("moarsigns", materialInfo.path.replace("/", "_") + materialInfo.materialName);
        }
        registry.register(new ShapedOreRecipe(group, result, new Object[]{true, "XXX", "XXX", " / ", Character.valueOf('X'), ingredient, Character.valueOf('/'), "stickWood"}).setRegistryName(location));
    }

    private static void replaceRecipes(IForgeRegistry<IRecipe> registry) {
        Collection recipes = registry.getValuesCollection();
        ItemStack signStack = new ItemStack(Items.SIGN);
        for (IRecipe tmpRecipe : recipes) {
            NonNullList ingredients = tmpRecipe.getIngredients();
            for (Ingredient stack : ingredients) {
                if (!stack.apply(signStack)) continue;
                HashMap map = Maps.newHashMap();
                MoarSigns.logger.info("Found recipe with sign: " + tmpRecipe.getRegistryName());
            }
        }
    }

    private static void removeRecipesWithResult(IForgeRegistry<IRecipe> registry, ItemStack resultItem) {
        for (IRecipe tmpRecipe : registry) {
            ItemStack recipeResult = tmpRecipe.getRecipeOutput();
            if (!ItemStack.areItemStacksEqual((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            MoarSigns.logger.debug("Removing Recipe: " + tmpRecipe + " -> " + recipeResult);
            ((ForgeRegistry)registry).remove(tmpRecipe.getRegistryName());
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            NuggetRegistry.init();
            Item[] items = new Item[]{SIGN, DEBUG, NUGGET, SIGN_TOOLBOX};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void preregisterRecipes(RegistryEvent.Register<IRecipe> event) {
            new IntegrationHandler().setupSigns();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry registry = event.getRegistry();
            ModItems.registerRecipes((IForgeRegistry<IRecipe>)registry);
        }
    }
}

