/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.IntegrationRegistry;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.integration.basemetals.BasemetalsIntegration;
import gory_moon.moarsigns.integration.bigrectors.BigReactorsIntegration;
import gory_moon.moarsigns.integration.bop.BiomesOPlentyIntegration;
import gory_moon.moarsigns.integration.draconicevolution.DraconicEvolutionIntegration;
import gory_moon.moarsigns.integration.enderio.EnderIOIntegration;
import gory_moon.moarsigns.integration.forestry.ForestryIntegration;
import gory_moon.moarsigns.integration.ic2.IndustrialCraft2Integration;
import gory_moon.moarsigns.integration.id.IntegratedDynamicsIntegration;
import gory_moon.moarsigns.integration.ie.ImmersiveEngineeringIntegration;
import gory_moon.moarsigns.integration.natura.NaturaIntegration;
import gory_moon.moarsigns.integration.psi.PsiIntegration;
import gory_moon.moarsigns.integration.randomthings.RandomThingsIntegration;
import gory_moon.moarsigns.integration.tconstruct.TinkersConstructIntegration;
import gory_moon.moarsigns.integration.techreborn.TechRebornIntegration;
import gory_moon.moarsigns.integration.thermalfoundation.ThermalFoundationIntegration;
import gory_moon.moarsigns.integration.vanilla.MinecraftIntegration;
import gory_moon.moarsigns.util.IntegrationException;
import java.util.ArrayList;
import net.minecraftforge.fml.common.Loader;

public class IntegrationHandler {
    private static boolean preSetup = true;

    private static void registerSigns(boolean log) {
        if (log) {
            MoarSigns.logger.info("Starting sign integrations");
        }
        ArrayList<ISignRegistration> signReg = IntegrationRegistry.getSignReg();
        for (ISignRegistration reg : signReg) {
            try {
                reg.registerSigns();
            }
            catch (IntegrationException e) {
                if (!Loader.isModLoaded((String)reg.getActivateTag()) || !log) continue;
                MoarSigns.logger.error("Failed " + reg.getIntegrationName() + " SignIntegration" + e.getMessage());
                continue;
            }
            if (!Loader.isModLoaded((String)reg.getActivateTag())) continue;
            SignRegistry.activateTag(reg.getActivateTag());
            if (!log) continue;
            MoarSigns.logger.info("Loaded " + reg.getIntegrationName() + " SignIntegration");
        }
        if (log) {
            MoarSigns.logger.info("Finished " + SignRegistry.getActiveTagsAmount() + " sign integrations with " + SignRegistry.getActivatedSignRegistry().size() + " signs registered");
        }
        SignRegistry.sortRegistry();
    }

    public void preSetupSigns() {
        IntegrationHandler.registerSigns(false);
        preSetup = false;
    }

    public void setupSigns() {
        IntegrationHandler.registerSigns(true);
    }

    public static boolean donePreSetup() {
        return !preSetup;
    }

    static {
        IntegrationRegistry.registerIntegration(MinecraftIntegration.class);
        IntegrationRegistry.registerIntegration(ForestryIntegration.class);
        IntegrationRegistry.registerIntegration(BiomesOPlentyIntegration.class);
        IntegrationRegistry.registerIntegration(IndustrialCraft2Integration.class);
        IntegrationRegistry.registerIntegration(TinkersConstructIntegration.class);
        IntegrationRegistry.registerIntegration(BasemetalsIntegration.class);
        IntegrationRegistry.registerIntegration(TechRebornIntegration.class);
        IntegrationRegistry.registerIntegration(NaturaIntegration.class);
        IntegrationRegistry.registerIntegration(PsiIntegration.class);
        IntegrationRegistry.registerIntegration(BigReactorsIntegration.class);
        IntegrationRegistry.registerIntegration(ImmersiveEngineeringIntegration.class);
        IntegrationRegistry.registerIntegration(IntegratedDynamicsIntegration.class);
        IntegrationRegistry.registerIntegration(DraconicEvolutionIntegration.class);
        IntegrationRegistry.registerIntegration(EnderIOIntegration.class);
        IntegrationRegistry.registerIntegration(RandomThingsIntegration.class);
        IntegrationRegistry.registerIntegration(ThermalFoundationIntegration.class);
    }
}

