/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.ShapelessMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.items.ItemDebug;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemNugget;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.NuggetRegistry;
import gory_moon.moarsigns.util.IMoarSignsRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@GameRegistry.ObjectHolder(value="moarsigns")
public class ModItems {
    public static final ItemMoarSign SIGN = new ItemMoarSign();
    public static final ItemDebug DEBUG = new ItemDebug();
    public static final ItemNugget NUGGET = new ItemNugget();
    public static final ItemSignToolbox SIGN_TOOLBOX = new ItemSignToolbox();
    public static boolean replaceRecipes = true;

    public static void registerRecipes() {
        RecipeSorter.register((String)"moarsigns:shaped", ShapedMoarSignRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"moarsigns:shapeless", ShapelessMoarSignRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ModItems.removeRecipesWithResult(new ItemStack(Items.SIGN, 3));
        ArrayList list = new ArrayList();
        SIGN.getSubItemStacks(list);
        ItemStack generalSign = null;
        for (ItemStack stack : list) {
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            boolean isMetal = stack.getItemDamage() == 1;
            stack.stackSize = 3;
            if (texture.equals("oak_sign")) {
                generalSign = stack;
                continue;
            }
            SignInfo s = SignRegistry.get(texture);
            List<MaterialInfo> materials = SignRegistry.getAlternativeMaterials(s);
            MaterialInfo material = s != null ? s.material : null;
            materials.add(0, material);
            for (MaterialInfo infos : materials) {
                ItemStack mat = infos.material;
                if (mat == null || mat.getItem() == null || material == null) continue;
                if (isMetal) {
                    ModItems.handleMetalSign(mat, material, stack);
                    stack.stackSize = 9;
                }
                ModItems.registerSignRecipe(mat, stack);
            }
        }
        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(generalSign, true, true, "###", "###", " X ", Character.valueOf('#'), "plankWood", Character.valueOf('X'), "stickWood"));
        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(SIGN_TOOLBOX, new Object[]{"rxr", "xsx", "rxr", Character.valueOf('x'), "ingotIron", Character.valueOf('s'), ShapedMoarSignRecipe.MatchType.ALL, Character.valueOf('r'), "dyeRed"}));
        if (replaceRecipes) {
            ModItems.replaceRecipes();
        }
    }

    private static void handleMetalSign(ItemStack mat, MaterialInfo material, ItemStack stack) {
        Container dummyContainer = new Container(){

            public boolean canInteractWith(EntityPlayer entityplayer) {
                return true;
            }

            public void onCraftMatrixChanged(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 2, 2);
        mat.stackSize = 1;
        if (mat.getItem() instanceof ItemBlock) {
            crafting.setInventorySlotContents(0, mat);
            mat = CraftingManager.getInstance().findMatchingRecipe(crafting, null);
        }
        ItemStack recNugget = null;
        if (mat != null) {
            mat.stackSize = 1;
            if (!material.gotNugget) {
                String unlocName = mat.getUnlocalizedName();
                NuggetRegistry.NuggetInfo nuggetInfo = NuggetRegistry.getNuggetInfo(unlocName);
                if (nuggetInfo != null) {
                    nuggetInfo.needed = true;
                    recNugget = new ItemStack((Item)NUGGET, 1, nuggetInfo.id);
                    OreDictionary.registerOre((String)nuggetInfo.oreName, (ItemStack)recNugget.copy());
                    recNugget.stackSize = 9;
                    GameRegistry.addShapelessRecipe((ItemStack)recNugget.copy(), (Object[])new Object[]{mat});
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(mat, new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), nuggetInfo.oreName}));
                }
            } else {
                crafting.setInventorySlotContents(0, mat);
                recNugget = CraftingManager.getInstance().findMatchingRecipe(crafting, null);
            }
        }
        if (recNugget != null && recNugget.getItem() != null) {
            ModItems.registerNuggetSign(recNugget, stack);
        }
    }

    private static void registerNuggetSign(ItemStack nuggetMaterial, ItemStack stack) {
        ItemStack result = stack.copy();
        result.stackSize = 1;
        nuggetMaterial.stackSize = 1;
        if (nuggetMaterial.getUnlocalizedName().equals("item.moarsigns.diamond_nugget")) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "diamondNugget", Character.valueOf('/'), "stickWood"));
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetDiamond", Character.valueOf('/'), "stickWood"));
        } else if (nuggetMaterial.getUnlocalizedName().equals("item.moarsigns.iron_nugget")) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetIron", Character.valueOf('/'), "stickWood"));
        } else if (nuggetMaterial.getUnlocalizedName().equals("item.moarsigns.emerald_nugget")) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetEmerald", Character.valueOf('/'), "stickWood"));
        } else if (nuggetMaterial.getUnlocalizedName().equals("item.moarsigns.lapis_nugget")) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetLapis", Character.valueOf('/'), "stickWood"));
        } else if (nuggetMaterial.getUnlocalizedName().equals("item.moarsigns.quartz_nugget")) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetQuartz", Character.valueOf('/'), "stickWood"));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), nuggetMaterial, Character.valueOf('/'), "stickWood"));
        }
    }

    private static void registerSignRecipe(ItemStack material, ItemStack result) {
        if (material.getUnlocalizedName().equals(Items.DIAMOND.getUnlocalizedName())) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "gemDiamond", Character.valueOf('/'), "stickWood"));
        } else if (material.getUnlocalizedName().equals(Items.EMERALD.getUnlocalizedName())) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "gemEmerald", Character.valueOf('/'), "stickWood"));
        } else if (material.getUnlocalizedName().equals(Items.IRON_INGOT.getUnlocalizedName())) {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "ingotIron", Character.valueOf('/'), "stickWood"));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), material, Character.valueOf('/'), "stickWood"));
        }
    }

    private static void replaceRecipes() {
        ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
        ItemStack signStack = new ItemStack(Items.SIGN);
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ArrayList input = null;
            if (tmpRecipe instanceof ShapedRecipes) {
                input = Arrays.asList(((ShapedRecipes)tmpRecipe).recipeItems);
            } else if (tmpRecipe instanceof ShapelessRecipes) {
                input = ((ShapelessRecipes)tmpRecipe).recipeItems;
            } else if (tmpRecipe instanceof ShapedOreRecipe) {
                input = Arrays.asList(((ShapedOreRecipe)tmpRecipe).getInput());
            } else if (tmpRecipe instanceof ShapelessOreRecipe) {
                input = ((ShapelessOreRecipe)tmpRecipe).getInput();
            }
            if (input == null) continue;
            for (Object stack : input) {
                if (!(stack instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)stack), (ItemStack)signStack, (boolean)false)) continue;
                HashMap map = Maps.newHashMap();
                map.put(signStack, ShapedMoarSignRecipe.MatchType.ALL);
                IMoarSignsRecipe replacement = null;
                if (tmpRecipe instanceof ShapedRecipes || tmpRecipe instanceof ShapedOreRecipe) {
                    replacement = new ShapedMoarSignRecipe(tmpRecipe, map);
                    GameRegistry.addRecipe((IRecipe)replacement);
                }
                if (tmpRecipe instanceof ShapelessRecipes || tmpRecipe instanceof ShapelessOreRecipe) {
                    replacement = new ShapelessMoarSignRecipe(tmpRecipe, map);
                    GameRegistry.addRecipe((IRecipe)replacement);
                }
                MoarSigns.logger.info("Replacing Recipe: " + tmpRecipe + " (containing " + stack + ") -> " + replacement);
                recipes.remove(scan);
            }
        }
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.getRecipeOutput();
            if (!ItemStack.areItemStacksEqual((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            MoarSigns.logger.debug("Removing Recipe: " + recipes.get(scan) + " -> " + recipeResult);
            recipes.remove(scan);
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            NuggetRegistry.init();
            Item[] items = new Item[]{SIGN, DEBUG, NUGGET, SIGN_TOOLBOX};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }
    }
}

