/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.jei.crafting;

import gory_moon.moarsigns.integration.jei.crafting.MoarSignsRecipeWrapper;
import gory_moon.moarsigns.util.IMoarSignsRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShapelessMoarSignsRecipeWrapper
extends MoarSignsRecipeWrapper
implements ICraftingRecipeWrapper {
    private static final double shapelessIconScale = 0.5;
    private final IDrawable shapelessIcon;
    private final HoverChecker shapelessIconHoverChecker;
    protected final IMoarSignsRecipe recipe;

    public ShapelessMoarSignsRecipeWrapper(IMoarSignsRecipe recipe, IGuiHelper guiHelper) {
        super(recipe);
        ResourceLocation shapelessIconLocation = new ResourceLocation("jei", "textures/gui/recipeBackground2.png");
        this.shapelessIcon = guiHelper.createDrawable(shapelessIconLocation, 196, 0, 19, 15);
        int iconBottom = (int)((double)this.shapelessIcon.getHeight() * 0.5);
        int iconLeft = 116 - (int)((double)this.shapelessIcon.getWidth() * 0.5);
        int iconRight = iconLeft + (int)((double)this.shapelessIcon.getWidth() * 0.5);
        this.shapelessIconHoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight, 0);
        this.recipe = recipe;
        for (Object input : this.recipe.getInput()) {
            if (!(input instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)input;
            if (itemStack.stackSize == 1) continue;
            itemStack.stackSize = 1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.hasMultipleIngredients()) {
            int shapelessIconX = recipeWidth - (int)((double)this.shapelessIcon.getWidth() * 0.5);
            GlStateManager.pushMatrix();
            GlStateManager.scale((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.shapelessIcon.draw(minecraft, (int)((double)shapelessIconX / 0.5), 0);
            GlStateManager.popMatrix();
        }
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hasMultipleIngredients() && this.shapelessIconHoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(I18n.translateToLocal((String)"jei.tooltip.shapeless.recipe"));
        }
        return super.getTooltipStrings(mouseX, mouseY);
    }

    private boolean hasMultipleIngredients() {
        return this.getInputs().size() > 1;
    }
}

