/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.enderio;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.api.SignSpecialProperty;
import gory_moon.moarsigns.util.IntegrationException;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EnderIOIntegration
implements ISignRegistration {
    private static final String ENDERIO_ID = "EnderIO";
    private static final String ENDERIO_NAME = "Ender IO";
    private Item item;
    private Item itemBlock;

    @Override
    public void registerWoodenSigns(ArrayList<ItemStack> planks) throws IntegrationException {
    }

    @Override
    public void registerMetalSigns(ArrayList<ItemStack> metals) throws IntegrationException {
        for (ItemStack stack : metals) {
            if (stack.getUnlocalizedName().equals("enderio.electricalSteel") && this.item == null) {
                this.item = stack.getItem();
            }
            if (stack.getUnlocalizedName().equals("tile.enderio.electricalSteel") && this.itemBlock == null) {
                this.itemBlock = stack.getItem();
            }
            if (this.item == null || this.itemBlock == null) continue;
            break;
        }
        this.registerMetal("electricalsteel_sign", null, "electricalsteel", false, 0, 0);
        this.registerMetal("energeticalloy_sign", null, "energeticalloy", false, 1, 1);
        this.registerMetal("vibrantalloy_sign", null, "vibrantalloy", true, 2, 2);
        this.registerMetal("redstonealloy_sign", null, "redstonealloy", false, 3, 3);
        this.registerMetal("conductiveiron_sign", null, "conductiveiron", false, 4, 4);
        this.registerMetal("pulsatingiron_sign", null, "pulsatingiron", true, 5, 5);
        this.registerMetal("darksteel_sign", null, "darksteel", false, 6, 6);
        this.registerMetal("soularium_sign", null, "soularium", false, 7, 7);
    }

    private void registerMetal(String name, SignSpecialProperty property, String materialName, boolean nugget, int meta, int blockMeta) throws IntegrationException {
        SignRegistry.register(name, property, materialName, "enderio/", nugget, new ItemStack(this.item, 1, meta), new ItemStack(this.itemBlock, 1, blockMeta), "moarsigns", ENDERIO_ID).setMetal();
    }

    @Override
    @Nonnull
    public String getActivateTag() {
        return ENDERIO_ID;
    }

    @Override
    @Nonnull
    public String getIntegrationName() {
        return Utils.getModName(ENDERIO_ID);
    }

    @Override
    @Nullable
    public String getModName() {
        return ENDERIO_NAME;
    }
}

