/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns;

import gory_moon.moarsigns.items.ModItems;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    private static ConfigHandler _instance = null;
    public Configuration config = null;

    private ConfigHandler() {
        _instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ConfigHandler instance() {
        return _instance == null ? new ConfigHandler() : _instance;
    }

    public void loadDefaultConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.syncConfigs();
    }

    public void saveConfig() {
        ConfigCategory cat = this.config.getCategory("general");
        Property prop = cat.get("replaceRecipes");
        prop.setValue(ModItems.replaceRecipes);
        cat.put("replaceRecipes", prop);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void syncConfigs() {
        ModItems.replaceRecipes = this.config.get("general", "replaceRecipes", true, "Replaces the vanilla sign in recipes with signs from MoarSigns").getBoolean();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("moarsigns")) {
            this.syncConfigs();
        }
    }
}

