package gory_moon.moarsigns.blocks;

import cofh.api.item.IToolHammer;
import crazypants.enderio.api.tool.ITool;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional.Interface;
import net.minecraftforge.fml.common.Optional.Method;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Random;

@Interface(iface = "mcjty.theoneprobe.api.IProbeInfoAccessor", modid = "theoneprobe")
public class BlockMoarSign extends BlockContainer implements IProbeInfoAccessor {

    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a("rotation", 0, 15);
    protected static final AxisAlignedBB SIGN_AABB = new AxisAlignedBB(0.25D, 0.0D, 0.25D, 0.75D, 1.0D, 0.75D);

    public BlockMoarSign(Material material, SoundType stepSound, float hardness, float resistance, String registryname, String harvestLevel, int level) {
        super(material);
        setRegistryName(registryname);
        func_149663_c("moarsign.sign");
        func_149672_a(stepSound);
        func_149711_c(hardness);
        func_149752_b(resistance);
        setHarvestLevel(harvestLevel, level);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SIGN_AABB;
    }

    @Nullable
    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_181623_g() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(ROTATION, rot.func_185833_a(state.func_177229_b(ROTATION), 16));
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a(ROTATION, mirrorIn.func_185802_a(state.func_177229_b(ROTATION), 16));
    }

    @Override
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        SignInfo signInfo = getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(state, world, pos, rand);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        SignInfo signInfo = getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, pos, state, entity);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolHammer && !(heldItem.func_77973_b() instanceof ItemSignToolbox) && ((IToolHammer) heldItem.func_77973_b()).isUsable(heldItem, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((IToolHammer) heldItem.func_77973_b()).toolUsed(heldItem, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }

        if (heldItem != null && heldItem.func_77973_b() instanceof ITool && ((ITool) heldItem.func_77973_b()).canUse(heldItem, player, pos)) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((ITool) heldItem.func_77973_b()).used(heldItem, player, pos);
            return true;
        }

        SignInfo signInfo = getSignInfo(world, pos);
        boolean returnVal = true;
        if (signInfo != null && signInfo.property != null) {
            returnVal = signInfo.property.onRightClick(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        }

        if (world.field_72995_K) {
            return returnVal;
        } else {
            TileEntity tileentity = world.func_175625_s(pos);
            return returnVal && (tileentity instanceof TileEntityMoarSign && ((TileEntityMoarSign) tileentity).func_174882_b(player));
        }
    }

    @SideOnly(Side.CLIENT)
    @Override
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double) pos.func_177958_n() + ((double) j + 0.5D) / (double) i;
                    double d1 = (double) pos.func_177956_o() + ((double) k + 0.5D) / (double) i;
                    double d2 = (double) pos.func_177952_p() + ((double) l + 0.5D) / (double) i;
                    effectRenderer.func_78873_a((new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double) pos.func_177958_n() - 0.5D, d1 - (double) pos.func_177956_o() - 0.5D, d2 - (double) pos.func_177952_p() - 0.5D, pos, state)).func_174846_a(pos));
                }
            }
        }

        return true;
    }

    @Override
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        BlockPos pos = target.func_178782_a();
        EnumFacing side = target.field_178784_b;
        IBlockState iblockstate = world.func_180495_p(pos);

        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1F;
        AxisAlignedBB axisalignedbb = iblockstate.func_185900_c(world, pos);
        double d0 = (double) i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double) (f * 2.0F)) + (double) f + axisalignedbb.field_72340_a;
        double d1 = (double) j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double) (f * 2.0F)) + (double) f + axisalignedbb.field_72338_b;
        double d2 = (double) k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double) (f * 2.0F)) + (double) f + axisalignedbb.field_72339_c;

        if (side == EnumFacing.DOWN) {
            d1 = (double) j + axisalignedbb.field_72338_b - (double) f;
        }

        if (side == EnumFacing.UP) {
            d1 = (double) j + axisalignedbb.field_72337_e + (double) f;
        }

        if (side == EnumFacing.NORTH) {
            d2 = (double) k + axisalignedbb.field_72339_c - (double) f;
        }

        if (side == EnumFacing.SOUTH) {
            d2 = (double) k + axisalignedbb.field_72334_f + (double) f;
        }

        if (side == EnumFacing.WEST) {
            d0 = (double) i + axisalignedbb.field_72340_a - (double) f;
        }

        if (side == EnumFacing.EAST) {
            d0 = (double) i + axisalignedbb.field_72336_d + (double) f;
        }

        effectRenderer.func_78873_a((new EntityDiggingFXMoarSigns(world, d0, d1, d2, 0.0D, 0.0D, 0.0D, pos, iblockstate)).func_174846_a(pos).func_70543_e(0.2F).func_70541_f(0.6F));
        return true;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign) world.func_175625_s(pos);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.SIGN.createMoarItemStack(s, tileEntity.isMetal);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        func_176226_b(world, pos, state, 0);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {

        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign) entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null)
                return ret;

            ret.add(ModItems.SIGN.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign)
            ((TileEntityMoarSign) entity).removeNoDrop = player.field_71075_bZ.field_75098_d;
        return super.removedByPlayer(state, world, pos, player, false);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return !this.func_181087_e(world, pos) && super.func_176196_c(world, pos);
    }

    public SignInfo getSignInfo(World world, BlockPos pos) {

        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign) tileEntity;
            return SignRegistry.get(sign.texture_name);
        }

        return null;
    }

    // The One Probe Integration
    @Method(modid = "theoneprobe")
    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {

        SignInfo info = getSignInfo(world, data.getPos());
        String modName = info.activateTag.equals(SignRegistry.ALWAYS_ACTIVE_TAG) ? "Minecraft" : info.activateTag;

        probeInfo.text(Colors.LIGHTGRAY + Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate(Colors.WHITE + Utils.getModName(modName)));

        if (mode.equals(ProbeMode.EXTENDED) || mode.equals(ProbeMode.DEBUG)) {
            probeInfo.text(Colors.LIGHTGRAY + Localization.ITEM.SIGN.MATERIAL.translate(Colors.WHITE + info.material.materialName));
        }
    }
}
