/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.ie;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.api.SignSpecialProperty;
import gory_moon.moarsigns.util.IntegrationException;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ImmersiveEngineeringIntegration
implements ISignRegistration {
    private static final String IE_ID = "immersiveengineering";
    private static final String IE_NAME = "Immersive Engineering";
    private static final String PATH = "ie/";
    private Item item;
    private Item itemWood;
    private Item itemBlock;

    @Override
    public void registerWoodenSigns(ArrayList<ItemStack> planks) throws IntegrationException {
        for (ItemStack stack : planks) {
            if (!stack.getUnlocalizedName().startsWith("tile.immersiveengineering.treatedWood")) continue;
            this.itemWood = stack.getItem();
            break;
        }
        SignRegistry.register("treatedwood_sign", null, "treatedwood", PATH, false, new ItemStack(this.itemWood, 0, 0), "moarsigns", IE_ID);
    }

    @Override
    public void registerMetalSigns(ArrayList<ItemStack> metals) throws IntegrationException {
        for (ItemStack stack : metals) {
            if (stack.getUnlocalizedName().startsWith("item.immersiveengineering.metal.") && this.item == null) {
                this.item = stack.getItem();
            }
            if (stack.getUnlocalizedName().startsWith("tile.immersiveengineering.storage.") && this.itemBlock == null) {
                this.itemBlock = stack.getItem();
            }
            if (this.item == null || this.itemBlock == null) continue;
            break;
        }
        this.registerMetal("copper_sign", null, "copper", this.item, 0, this.itemBlock, 0);
        this.registerMetal("aluminium_sign", null, "aluminium", this.item, 1, this.itemBlock, 1);
        this.registerMetal("lead_sign", null, "lead", this.item, 2, this.itemBlock, 2);
        this.registerMetal("silver_sign", null, "silver", this.item, 3, this.itemBlock, 3);
        this.registerMetal("nickel_sign", null, "nickel", this.item, 4, this.itemBlock, 4);
        this.registerMetal("uranium_sign", null, "uranium", this.item, 5, this.itemBlock, 5);
        this.registerMetal("constantan_sign", null, "constantan", this.item, 6, this.itemBlock, 6);
        this.registerMetal("electrum_sign", null, "electrum", this.item, 7, this.itemBlock, 7);
        this.registerMetal("steel_sign", null, "steel", this.item, 8, this.itemBlock, 8);
    }

    private void registerMetal(String name, SignSpecialProperty property, String materialName, Item item, int meta, Item block, int blockMeta) throws IntegrationException {
        SignRegistry.register(name, property, materialName, PATH, true, new ItemStack(item, 1, meta), new ItemStack(block, 1, blockMeta), "moarsigns", IE_ID).setMetal();
    }

    @Override
    @Nonnull
    public String getActivateTag() {
        return IE_ID;
    }

    @Override
    @Nonnull
    public String getIntegrationName() {
        return Utils.getModName(IE_ID);
    }

    @Override
    @Nullable
    public String getModName() {
        return IE_NAME;
    }
}

