/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.tileentites;

import com.google.gson.JsonParseException;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.World;

public class TileEntityMoarSign
extends TileEntitySign
implements ITickable {
    public static final String NBT_VERSION_TAG = "nbtVersion";
    public static final String NBT_SETTINGS_TAG = "settings";
    public static final String NBT_LOCKED_CHANGES_TAG = "lockedChanges";
    public static final String NBT_METAL_TAG = "isMetal";
    public static final String NBT_TEXTURE_TAG = "texture";
    private final int NBT_VERSION = 2;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public boolean isMetal = false;
    public String texture_name;
    public boolean showInGui = false;
    public boolean removeNoDrop;
    private boolean isEditable = true;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;

    public TileEntityMoarSign() {
        for (int i = 0; i < 4; ++i) {
            this.rowLocations[i] = 2 + 10 * i;
        }
    }

    public void setBlockType(Block block) {
        this.field_145854_h = block;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            SignInfo sign;
            if (!this.textureReq) {
                this.textureReq = true;
                Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
                this.field_145850_b.func_175641_c(this.field_174879_c, block, 0, 0);
            }
            if ((sign = SignRegistry.get(this.texture_name)) != null && sign.property != null) {
                sign.property.onUpdate();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(NBT_VERSION_TAG, 2);
        NBTTagList settings = new NBTTagList();
        int[] loc = new int[5];
        loc[0] = 0;
        System.arraycopy(this.rowLocations, 0, loc, 1, 4);
        int[] size = new int[5];
        size[0] = 1;
        System.arraycopy(this.rowSizes, 0, size, 1, 4);
        int[] visible = new int[5];
        visible[0] = 2;
        for (int i = 0; i < 4; ++i) {
            visible[i + 1] = this.visibleRows[i] ? 1 : 0;
        }
        int[] shadow = new int[5];
        shadow[0] = 3;
        for (int i = 0; i < 4; ++i) {
            shadow[i + 1] = this.shadowRows[i] ? 1 : 0;
        }
        NBTTagIntArray locations = new NBTTagIntArray(loc);
        NBTTagIntArray sizes = new NBTTagIntArray(size);
        NBTTagIntArray hidden = new NBTTagIntArray(visible);
        NBTTagIntArray shadows = new NBTTagIntArray(shadow);
        settings.func_74742_a((NBTBase)locations);
        settings.func_74742_a((NBTBase)sizes);
        settings.func_74742_a((NBTBase)hidden);
        settings.func_74742_a((NBTBase)shadows);
        compound.func_74782_a(NBT_SETTINGS_TAG, (NBTBase)settings);
        compound.func_74757_a(NBT_LOCKED_CHANGES_TAG, this.lockedChanges);
        compound.func_74757_a(NBT_METAL_TAG, this.isMetal);
        if (this.texture_name != null) {
            compound.func_74778_a(NBT_TEXTURE_TAG, this.texture_name);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ICommandSender icommandsender = new ICommandSender(){

            public String func_70005_c_() {
                return "Sign";
            }

            public ITextComponent func_145748_c_() {
                return new TextComponentString(this.func_70005_c_());
            }

            public void func_145747_a(ITextComponent component) {
            }

            public boolean func_70003_b(int permLevel, String commandName) {
                return permLevel <= 2;
            }

            public BlockPos func_180425_c() {
                return TileEntityMoarSign.this.field_174879_c;
            }

            public Vec3d func_174791_d() {
                return new Vec3d((double)TileEntityMoarSign.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityMoarSign.this.field_174879_c.func_177956_o() + 0.5, (double)TileEntityMoarSign.this.field_174879_c.func_177952_p() + 0.5);
            }

            public World func_130014_f_() {
                return TileEntityMoarSign.this.field_145850_b;
            }

            public Entity func_174793_f() {
                return null;
            }

            public boolean func_174792_t_() {
                return false;
            }

            public void func_174794_a(CommandResultStats.Type type, int amount) {
            }

            public MinecraftServer func_184102_h() {
                return TileEntityMoarSign.this.field_145850_b.func_73046_m();
            }
        };
        int nbtVersion = compound.func_74762_e(NBT_VERSION_TAG);
        if (nbtVersion == 1) {
            int fontSize = compound.func_74762_e("fontSize");
            int rows = Utils.getRows(fontSize);
            this.rowSizes = new int[]{fontSize, fontSize, fontSize, fontSize};
            this.visibleRows = new boolean[]{false, false, false, false};
            for (int i = 0; i < rows; ++i) {
                this.visibleRows[i] = true;
            }
            int textOffset = compound.func_74762_e("textOffset");
            for (int i = 0; i < 4; ++i) {
                int temp = Math.abs(textOffset) + this.rowLocations[i] - (textOffset != 0 ? 2 : 0);
                if (temp < 0) {
                    temp = 0;
                }
                this.rowLocations[i] = temp;
            }
        } else if (nbtVersion == 2) {
            this.lockedChanges = compound.func_74767_n(NBT_LOCKED_CHANGES_TAG);
            NBTTagList settings = compound.func_150295_c(NBT_SETTINGS_TAG, 11);
            for (int i = 0; i < settings.func_74745_c(); ++i) {
                int j;
                int[] array = settings.func_150306_c(i);
                if (array[0] == 0) {
                    System.arraycopy(array, 1, this.rowLocations, 0, 4);
                    continue;
                }
                if (array[0] == 1) {
                    System.arraycopy(array, 1, this.rowSizes, 0, 4);
                    continue;
                }
                if (array[0] == 2) {
                    int[] hidden = new int[4];
                    System.arraycopy(array, 1, hidden, 0, 4);
                    for (j = 0; j < 4; ++j) {
                        this.visibleRows[j] = hidden[j] == 1;
                    }
                    continue;
                }
                if (array[0] != 3) continue;
                int[] shadows = new int[4];
                System.arraycopy(array, 1, shadows, 0, 4);
                for (j = 0; j < 4; ++j) {
                    this.shadowRows[j] = shadows[j] == 1;
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            try {
                ITextComponent ichatcomponent = ITextComponent.Serializer.func_150699_a((String)s);
                try {
                    this.field_145915_a[i] = TextComponentUtils.func_179985_a((ICommandSender)icommandsender, (ITextComponent)ichatcomponent, (Entity)null);
                }
                catch (CommandException var7) {
                    this.field_145915_a[i] = ichatcomponent;
                }
                continue;
            }
            catch (JsonParseException var8) {
                this.field_145915_a[i] = new TextComponentString(s);
            }
        }
        if (compound.func_74764_b(NBT_METAL_TAG)) {
            this.isMetal = compound.func_74767_n(NBT_METAL_TAG);
        }
        if (compound.func_74764_b(NBT_TEXTURE_TAG)) {
            this.texture_name = compound.func_74779_i(NBT_TEXTURE_TAG);
        }
        if (this.texture_name == null || this.texture_name.isEmpty()) {
            this.texture_name = "oak_sign";
        }
        this.setResourceLocation(this.texture_name);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_70296_d();
    }

    public boolean func_145914_a() {
        return this.isEditable;
    }

    public void setEditAble(boolean state) {
        this.isEditable = state;
        if (!state) {
            this.playerEditing = null;
        }
    }

    public void func_145913_a(boolean editable) {
        this.setEditAble(editable);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.texture_name = texture;
        } else if (this.resourceLocation == null) {
            this.texture_name = texture;
            this.resourceLocation = Utils.getResourceLocation(texture, this.isMetal);
        }
    }

    public void func_145912_a(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    public EntityPlayer func_145911_b() {
        return this.playerEditing;
    }

    public boolean canRenderBreaking() {
        return true;
    }
}

