/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import se.gory_moon.horsepower.util.Utils;

public abstract class HPRecipeBase {
    private ItemStack input;
    private ItemStack output;
    private FluidStack outputFluid;
    private ItemStack secondary;
    private int time;
    private int secondaryChance;

    public HPRecipeBase(ItemStack input, ItemStack output, ItemStack secondary, int secondaryChance, int time) {
        this.input = input;
        this.output = output;
        this.time = time;
        this.secondary = secondary;
        this.secondaryChance = MathHelper.clamp((int)secondaryChance, (int)0, (int)100);
    }

    public HPRecipeBase(ItemStack input, FluidStack output, int time) {
        this.input = input;
        this.output = ItemStack.EMPTY;
        this.outputFluid = output;
        this.secondary = ItemStack.EMPTY;
        this.time = time;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public ItemStack getSecondary() {
        return this.secondary;
    }

    public int getSecondaryChance() {
        return this.secondaryChance;
    }

    public int getTime() {
        return this.time;
    }

    public static ItemStack getWithSize(ItemStack stack, int size) {
        stack.setCount(size);
        return stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HPRecipeBase)) {
            return false;
        }
        HPRecipeBase recipe = (HPRecipeBase)o;
        return this.time == recipe.time && this.secondaryChance == recipe.secondaryChance && this.input.isItemEqual(recipe.input) && this.output.isItemEqual(recipe.output) && this.secondary.isItemEqual(recipe.secondary);
    }

    public int hashCode() {
        int result = Utils.getItemStackHashCode(this.input);
        result = 31 * result + Utils.getItemStackHashCode(this.output);
        result = 31 * result + Utils.getItemStackHashCode(this.secondary);
        result = 31 * result + this.secondaryChance;
        result = 31 * result + this.time;
        return result;
    }

    public String toString() {
        return this.input + " -> " + this.output + (this.time > -1 ? " = " + this.time : "") + (!this.secondary.isEmpty() ? "{" + this.secondary + "->" + this.secondaryChance + "%}" : "");
    }
}

