package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.client.model.modelvariants.GrindStoneModels;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.util.RenderUtils;

public class TileEntityGrindstoneRender extends TileEntityHPBaseRenderer<TileEntityGrindstone> {

    @Override
    public void func_192841_a(TileEntityGrindstone te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;
        ItemStack outputStack = te.getStackInSlot(1);
        ItemStack secondaryStack = te.getStackInSlot(2);
        if (outputStack.func_190916_E() < secondaryStack.func_190916_E())
            outputStack = secondaryStack;

        if (blockState.func_177229_b(BlockGrindstone.FILLED)) {
            IBlockState filledState = blockState.func_177226_a(BlockGrindstone.PART, GrindStoneModels.FILLED);
            if (!(filledState.func_177230_c() instanceof BlockHPBase)) return;

            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();

            IBakedModel filledModel = dispatcher.func_175023_a().func_178125_b(filledState);

            setRenderSettings();

            buffer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
            buffer.func_178969_c(-te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p());

            dispatcher.func_175019_b().func_178267_a(te.func_145831_w(), filledModel, filledState, te.func_174877_v(), buffer, false);

            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b(x, y, z);

            GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
            float maxStackSize = outputStack.func_77976_d() > 0 ? outputStack.func_77976_d(): 1F;
            float fillState = 0.23F * (((float)outputStack.func_190916_E()) / maxStackSize);
            GlStateManager.func_179137_b( 0, -0.187 + fillState, 0 );
            GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            buffer.func_178969_c(0.0D, 0.0D, 0.0D);
            RenderHelper.func_74519_b();
        } else if (outputStack.func_190926_b()) {
            te.renderStack = ItemStack.field_190927_a;
            te.grindColor = null;
        }

        if (te.hasWorker())
            renderLeash(te.getWorker(), x, y, z, 0D, 0D, 0D, partialTicks, te.func_174877_v());

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x, y, z);
        if (!te.getStackInSlot(0).func_190926_b()) {
            renderItem(te, te.getStackInSlot(0), 0.5F, 1F, 0.5F, 1F);
            if (func_178459_a().func_175623_d(te.func_174877_v().func_177984_a()))
                drawString(te, String.valueOf(te.getStackInSlot(0).func_190916_E()), 0, 0.35, 0);
        }
        GlStateManager.func_179121_F();

        GlStateManager.func_179094_E();

        drawDisplayText(te, x, y, z);

        if (!te.isValid())
            RenderUtils.renderInvalidArea(te.func_145831_w(), te.func_174877_v(), -1);
        GlStateManager.func_179121_F();
    }
}
