/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.client.renderer.FacingToRotation;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public abstract class TileEntityHPBaseRenderer<T extends TileEntityHPBase>
extends TileEntitySpecialRenderer<T> {
    private static TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    protected void renderStillItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        this.renderItem(te, stack, x, y, z, scale, false);
    }

    protected void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        this.renderItem(te, stack, x, y, z, scale, true);
    }

    private void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale, boolean rotate) {
        RenderItem itemRenderer = Minecraft.getMinecraft().getRenderItem();
        if (stack != null) {
            GlStateManager.translate((float)x, (float)y, (float)z);
            EntityItem entityitem = new EntityItem(te.getWorld(), 0.0, 0.0, 0.0, stack.copy());
            entityitem.hoverStart = 0.0f;
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            if (rotate) {
                GlStateManager.rotate((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.scale((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
            GlStateManager.pushAttrib();
            RenderHelper.enableStandardItemLighting();
            itemRenderer.renderItem(entityitem.getItem(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.popAttrib();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }

    public void drawString(TileEntityHPBase te, String str, double x, double y, double z) {
        if (!this.canShowAmount(te)) {
            return;
        }
        this.setLightmapDisabled(true);
        Entity entity = this.rendererDispatcher.entity;
        double d0 = te.getDistanceSq(entity.posX, entity.posY, entity.posZ);
        if (d0 <= 196.0) {
            float f = this.rendererDispatcher.entityYaw;
            float f1 = this.rendererDispatcher.entityPitch;
            FontRenderer fontRenderer = this.getFontRenderer();
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)x, (double)y, (double)z);
            GlStateManager.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            if (te.getForward() == EnumFacing.EAST || te.getForward() == EnumFacing.WEST) {
                FacingToRotation.get(te.getForward().getOpposite()).glRotateCurrentMat();
            } else {
                FacingToRotation.get(te.getForward()).glRotateCurrentMat();
            }
            GlStateManager.rotate((float)(-f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)f1, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scale((float)-0.015f, (float)-0.015f, (float)0.015f);
            GlStateManager.disableLighting();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepth();
            GlStateManager.enableBlend();
            GlStateManager.enableDepth();
            GlStateManager.depthMask((boolean)true);
            fontRenderer.drawString(str, -fontRenderer.getStringWidth(str) / 2, 0, -1);
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
        }
        this.setLightmapDisabled(false);
    }

    public boolean canShowAmount(TileEntityHPBase te) {
        return Configs.client.renderItemAmount && (!Configs.client.mustLookAtBlock || this.rendererDispatcher.cameraHitResult != null && te.getPos().equals((Object)this.rendererDispatcher.cameraHitResult.getBlockPos()));
    }

    protected void renderItemWithFacing(World world, TileEntityHPBase tile, ItemStack stack, double ox, double oy, double oz, float x, float y, float z, float scale) {
        if (stack.isEmpty()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)ox, (double)oy, (double)oz);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(tile.getForward()).glRotateCurrentMat();
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        this.renderItem(tile, stack, x, y, z, scale);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)ox, (double)oy, (double)oz);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(tile.getForward()).glRotateCurrentMat();
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        this.drawString(tile, String.valueOf(stack.getCount()), x, (double)y + 0.3, z);
        GlStateManager.popMatrix();
    }

    protected void renderBaseModel(TileEntityHPBase te, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z) {
        this.setRenderSettings();
        IBlockState blockState = te.getWorld().getBlockState(te.getPos());
        BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBakedModel model = dispatcher.getModelForState(blockState);
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        buffer.setTranslation((double)(-te.getPos().getX()), (double)(-te.getPos().getY()), (double)(-te.getPos().getZ()));
        dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, blockState, te.getPos(), buffer, false);
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        tessellator.draw();
        GlStateManager.popMatrix();
    }

    protected void renderBaseModelWithFacing(TileEntityHPBase te, IBlockState blockState, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z, int destroyStage) {
        this.preDestroyRender(destroyStage);
        this.setRenderSettings();
        BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBakedModel model = dispatcher.getModelForState(blockState);
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        buffer.setTranslation((double)(-te.getPos().getX()), (double)(-te.getPos().getY()), (double)(-te.getPos().getZ()));
        if (destroyStage >= 0) {
            buffer.noColor();
            this.renderBlockDamage(blockState, te.getPos(), TileEntityHPBaseRenderer.getDestroyBlockIcon(destroyStage), (IBlockAccess)te.getWorld());
        } else {
            dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, blockState, te.getPos(), buffer, false);
        }
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(te.getForward()).glRotateCurrentMat();
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.draw();
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.popMatrix();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.postDestroyRender(destroyStage);
        RenderHelper.enableStandardItemLighting();
    }

    protected void setRenderSettings() {
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
    }

    protected void preDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).setBlurMipmap(false, false);
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.enableBlend();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.doPolygonOffset((float)-3.0f, (float)-3.0f);
            GlStateManager.enablePolygonOffset();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableAlpha();
            GlStateManager.pushMatrix();
        }
    }

    protected void postDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.disableAlpha();
            GlStateManager.doPolygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.enableAlpha();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.popMatrix();
            Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).restoreLastBlurMipmap();
            GlStateManager.disableBlend();
        }
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityCreature entity, double ox, double oy, double oz, double x, double y, double z, float partialTicks, BlockPos pos) {
        if (entity != null) {
            oy -= 0.7;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = -1.0;
            double d9 = this.interpolateValue(entity.prevRenderYawOffset, entity.renderYawOffset, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)entity.width * 0.4;
            d3 = Math.sin(d9) * (double)entity.width * 0.4;
            double d6 = this.interpolateValue(entity.prevPosX, entity.posX, partialTicks) + d2;
            double d7 = this.interpolateValue(entity.prevPosY + (double)entity.getEyeHeight() * 1.1, entity.posY + (double)entity.getEyeHeight() * 1.1, partialTicks) - d4 * 0.5 - 0.25 - y;
            double d8 = this.interpolateValue(entity.prevPosZ, entity.posZ, partialTicks) + d3;
            d2 = 0.5;
            d3 = 0.5;
            double d10 = (double)pos.getX() + d2;
            double d11 = pos.getY();
            double d12 = (double)pos.getZ() + d3;
            this.renderLeach(d6, d7, d8, ox += d2 + x, oy += y, oz += d3 + z, d10, d11, d12);
        }
    }

    protected void renderLeach(double x1, double y1, double z1, double ox, double oy, double oz, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuffer();
        double d13 = (float)(x1 - x2);
        double d14 = (float)(y1 - y2);
        double d15 = (float)(z1 - z2);
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        vertexbuffer.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (int j = 0; j <= 24; ++j) {
            float f = 0.5f;
            float f1 = 0.4f;
            float f2 = 0.3f;
            if (j % 2 == 0) {
                f *= 0.7f;
                f1 *= 0.7f;
                f2 *= 0.7f;
            }
            float f3 = (float)j / 24.0f;
            vertexbuffer.pos(ox + d13 * (double)f3 + 0.0, oy + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), oz + d15 * (double)f3).color(f, f1, f2, 1.0f).endVertex();
            vertexbuffer.pos(ox + d13 * (double)f3 + 0.025, oy + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, oz + d15 * (double)f3).color(f, f1, f2, 1.0f).endVertex();
        }
        tessellator.draw();
        vertexbuffer.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (int k = 0; k <= 24; ++k) {
            float f4 = 0.5f;
            float f5 = 0.4f;
            float f6 = 0.3f;
            if (k % 2 == 0) {
                f4 *= 0.7f;
                f5 *= 0.7f;
                f6 *= 0.7f;
            }
            float f7 = (float)k / 24.0f;
            vertexbuffer.pos(ox + d13 * (double)f7 + 0.0, oy + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, oz + d15 * (double)f7).color(f4, f5, f6, 1.0f).endVertex();
            vertexbuffer.pos(ox + d13 * (double)f7 + 0.025, oy + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), oz + d15 * (double)f7 + 0.025).color(f4, f5, f6, 1.0f).endVertex();
        }
        tessellator.draw();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture2D();
        GlStateManager.enableCull();
    }

    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        state = state.getActualState(blockAccess, pos);
        IBakedModel ibakedmodel = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(state);
        IBakedModel ibakedmodel1 = ForgeHooksClient.getDamageModel((IBakedModel)ibakedmodel, (TextureAtlasSprite)texture, (IBlockState)state, (IBlockAccess)blockAccess, (BlockPos)pos);
        Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelRenderer().renderModel(blockAccess, ibakedmodel1, state, pos, Tessellator.getInstance().getBuffer(), true);
    }

    public static TextureAtlasSprite getDestroyBlockIcon(int destroyState) {
        if (destroyBlockIcons[destroyState] == null) {
            destroyBlockIcons = (TextureAtlasSprite[])ObfuscationReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)Minecraft.getMinecraft().renderGlobal, (String[])new String[]{"destroyBlockIcons", "field_94141_F"});
        }
        return destroyBlockIcons[destroyState];
    }

    public static void clearDestroyStageicons() {
        Arrays.stream(destroyBlockIcons).forEach(textureAtlasSprite -> {
            textureAtlasSprite = null;
        });
    }
}

