/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityHandGrindstone
extends TileEntityHPBase
implements ITickable {
    private int currentItemMillTime;
    private int totalItemMillTime;
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int currentTicks = 0;
    private int rotation = 0;

    public TileEntityHandGrindstone() {
        super(3);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("millTime", this.currentItemMillTime);
        compound.setInteger("totalMillTime", this.totalItemMillTime);
        compound.setInteger("currentRotation", this.rotation);
        return super.writeToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (this.getStackInSlot(0).getCount() > 0) {
            this.currentItemMillTime = compound.getInteger("millTime");
            this.totalItemMillTime = compound.getInteger("totalMillTime");
            this.rotation = compound.getInteger("currentRotation");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
            this.rotation = 0;
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(this.getStackInSlot(0), true);
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getGrindstoneRecipe(this.getStackInSlot(0), true);
    }

    private void millItem() {
        if (!this.world.isRemote && this.canWork()) {
            HPRecipeBase recipe = this.getRecipe();
            ItemStack result = recipe.getOutput();
            ItemStack secondary = recipe.getSecondary();
            ItemStack input = this.getStackInSlot(0);
            ItemStack output = this.getStackInSlot(1);
            ItemStack secondaryOutput = this.getStackInSlot(2);
            if (output.isEmpty()) {
                this.setInventorySlotContents(1, result.copy());
            } else if (output.isItemEqual(result)) {
                output.grow(result.getCount());
            }
            TileEntityHandGrindstone.processSecondaries(this.getWorld(), secondary, secondaryOutput, recipe, this);
            input.shrink(1);
        }
    }

    public static void processSecondaries(World world, ItemStack secondary, ItemStack secondaryOutput, HPRecipeBase recipe, TileEntityHPBase teBase) {
        int recipeChance;
        if (!(secondary.isEmpty() || (recipeChance = recipe.getSecondaryChance()) < 100 && world.rand.nextInt(100) >= recipeChance)) {
            if (secondaryOutput.isEmpty()) {
                teBase.setInventorySlotContents(2, secondary.copy());
            } else if (secondaryOutput.isItemEqual(secondary)) {
                secondaryOutput.grow(secondary.getCount());
            }
        }
    }

    @Override
    public void markDirty() {
        super.markDirty();
        if (this.getStackInSlot(0).isEmpty()) {
            this.currentItemMillTime = 0;
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        boolean bl = flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack, true);
            this.currentItemMillTime = 0;
        }
        this.markDirty();
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack, true);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public String getName() {
        return "container.hand_mill";
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    public boolean turn() {
        if (this.getWorld().isRemote) {
            return false;
        }
        if (this.rotation < 3 && this.canWork()) {
            this.rotation += 18;
            this.markDirty();
            return true;
        }
        return false;
    }

    public void update() {
        if (this.rotation > 0) {
            this.visibleRotation = (this.visibleRotation - 20.0f) % -360.0f;
            ++this.currentTicks;
            if (this.currentTicks >= 18) {
                this.currentTicks -= 18;
                this.currentItemMillTime += Configs.general.pointsPerRotation;
                if (this.currentItemMillTime >= this.totalItemMillTime) {
                    this.currentItemMillTime = 0;
                    this.millItem();
                    this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(this.getStackInSlot(0), true);
                }
                this.markDirty();
            }
            --this.rotation;
        } else {
            this.visibleRotation = 0.0f;
        }
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}

