/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HPEventHandler;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Localization;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChoppingBlock
extends BlockHPChoppingBase
implements IProbeInfoAccessor {
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockChoppingBlock() {
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setRegistryName("chopping_block");
        this.func_149663_c("chopping_block");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return player instanceof FakePlayer || player == null || super.func_180639_a(worldIn, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer player) {
        ItemStack held;
        if (player instanceof FakePlayer || player == null) {
            return;
        }
        TileEntityManualChopper te = (TileEntityManualChopper)((Object)this.getTileEntity((IBlockAccess)worldIn, pos));
        if (te != null && !(held = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && (held.func_77973_b().getHarvestLevel(held, "axe", player, null) > -1 || this.isItemWhitelisted(held)) && te.chop(player, held)) {
            player.func_71020_j((float)Configs.general.choppingblockExhaustion);
            if (Configs.general.shouldDamageAxe) {
                held.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        super.func_180649_a(worldIn, pos, player);
    }

    private boolean isItemWhitelisted(ItemStack stack) {
        for (ItemStack itemStack : HPEventHandler.choppingAxes.keySet()) {
            if (!ItemStack.func_185132_d((ItemStack)itemStack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    @Override
    @Nonnull
    public Class<?> getTileClass() {
        return TileEntityManualChopper.class;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (Configs.general.enableHandChoppingBlock) {
            super.func_149666_a(tab, list);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{SIDE_TEXTURE, TOP_TEXTURE});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityManualChopper tileEntity = (TileEntityManualChopper)((Object)this.getTileEntity((IBlockAccess)world, data.getPos()));
        if (tileEntity != null) {
            probeInfo.progress((long)((double)tileEntity.getField(1) / (double)tileEntity.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
        }
    }
}

