/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.tweaker.BaseHPAction;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Press")
public class PressRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output) {
        AddPressRecipe recipe = new AddPressRecipe(input, output, ItemStack.EMPTY, 0, 0);
        TweakerPluginImpl.toAdd.add(recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        RemovePressRecipe recipe = new RemovePressRecipe(output);
        TweakerPluginImpl.toRemove.add(recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemovePressRecipe
    extends BaseHPAction {
        private final IIngredient output;

        public RemovePressRecipe(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            ArrayList removeIndex = Lists.newArrayList();
            for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
                PressRecipe recipe = HPRecipes.instance().getPressRecipes().get(i);
                if (!OreDictionary.itemMatches((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
                removeIndex.add(i);
            }
            ArrayList<PressRecipe> recipeList = HPRecipes.instance().getPressRecipes();
            for (int i = removeIndex.size() - 1; i >= 0; --i) {
                recipeList.remove((Integer)removeIndex.get(i));
            }
        }

        public String describe() {
            return "Removing press recipes for " + this.output;
        }
    }

    private static class AddPressRecipe
    extends BaseHPAction {
        private final IIngredient input;
        private final IItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;

        public AddPressRecipe(IIngredient input, IItemStack output2, ItemStack secondary, int secondaryChance, int time) {
            this.input = input;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
        }

        public void apply() {
            List items = this.input.getItems();
            if (items == null) {
                HorsePowerMod.logger.error("Cannot turn " + this.input.toString() + " into a press recipe");
            }
            ItemStack[] items2 = CraftTweakerMC.getItemStacks((List)items);
            ItemStack output2 = CraftTweakerMC.getItemStack((IItemStack)this.output);
            for (ItemStack stack : items2) {
                PressRecipe recipe = new PressRecipe(stack, output2, this.secondary, this.secondary.isEmpty() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addPressRecipe(recipe);
            }
        }

        public String describe() {
            return "Adding press recipe for " + this.input;
        }
    }
}

