/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HPEventHandler;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Localization;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChoppingBlock
extends BlockHPChoppingBase
implements IProbeInfoAccessor {
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockChoppingBlock() {
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setRegistryName("chopping_block");
        this.setUnlocalizedName("chopping_block");
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return player instanceof FakePlayer || player == null || super.onBlockActivated(worldIn, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void onBlockClicked(World worldIn, BlockPos pos, EntityPlayer player) {
        ItemStack held;
        if (player instanceof FakePlayer || player == null) {
            return;
        }
        TileEntityManualChopper te = (TileEntityManualChopper)((Object)this.getTileEntity((IBlockAccess)worldIn, pos));
        if (te != null && !(held = player.getHeldItem(EnumHand.MAIN_HAND)).isEmpty() && (held.getItem().getHarvestLevel(held, "axe", player, null) > -1 || this.isItemWhitelisted(held)) && te.chop(player, held)) {
            player.addExhaustion((float)Configs.general.choppingblockExhaustion);
            if (Configs.general.shouldDamageAxe) {
                held.damageItem(1, (EntityLivingBase)player);
            }
        }
        super.onBlockClicked(worldIn, pos, player);
    }

    private boolean isItemWhitelisted(ItemStack stack) {
        for (ItemStack itemStack : HPEventHandler.choppingAxes.keySet()) {
            if (!ItemStack.areItemsEqualIgnoreDurability((ItemStack)itemStack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    @Override
    @Nonnull
    public Class<?> getTileClass() {
        return TileEntityManualChopper.class;
    }

    @Override
    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (Configs.general.enableHandChoppingBlock) {
            super.getSubBlocks(tab, list);
        }
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{SIDE_TEXTURE, TOP_TEXTURE});
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityManualChopper tileEntity = (TileEntityManualChopper)((Object)this.getTileEntity((IBlockAccess)world, data.getPos()));
        if (tileEntity != null) {
            probeInfo.progress((long)((double)tileEntity.getField(1) / (double)tileEntity.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
        }
    }
}

