/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.network.PacketHandler;
import se.gory_moon.horsepower.network.messages.SyncServerRecipesMessage;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.util.Utils;
import se.gory_moon.horsepower.util.color.Colors;

@Mod.EventBusSubscriber(modid="horsepower")
public class HPEventHandler {
    public static Map<ItemStack, Pair<Integer, Integer>> choppingAxes = new HashMap<ItemStack, Pair<Integer, Integer>>();
    public static Map<Integer, Pair<Integer, Integer>> harvestPercentages = new HashMap<Integer, Pair<Integer, Integer>>();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("horsepower")) {
            HPEventHandler.reloadConfig();
        }
    }

    public static void reloadConfig() {
        ConfigManager.sync((String)"horsepower", (Config.Type)Config.Type.INSTANCE);
        HPRecipes.instance().reloadRecipes();
        choppingAxes.clear();
        Arrays.stream(Configs.general.choppingBlockAxes).forEach(s -> {
            String[] data = s.split("=");
            int base = Utils.getBaseAmount(data[1]);
            int chance = Utils.getChance(data[1]);
            ItemStack stack = ItemStack.field_190927_a;
            try {
                stack = (ItemStack)Utils.parseItemStack(data[0], false, false);
            }
            catch (Exception e) {
                Utils.errorMessage("Parse error with item for custom axes for the chopping block");
            }
            if (!stack.func_190926_b()) {
                choppingAxes.put(stack, (Pair<Integer, Integer>)Pair.of((Object)base, (Object)chance));
            }
        });
        harvestPercentages.clear();
        Arrays.stream(Configs.general.harvestable_percentage).forEach(s -> {
            String[] data = s.split("=");
            try {
                int harvestLevel = Integer.parseInt(data[0]);
                int base = Utils.getBaseAmount(data[1]);
                int chance = Utils.getChance(data[1]);
                harvestPercentages.put(harvestLevel, (Pair<Integer, Integer>)Pair.of((Object)base, (Object)chance));
            }
            catch (NumberFormatException e) {
                Utils.errorMessage("HarvestLevel config is malformed, make sure only numbers are used as values, (" + s + ")");
            }
        });
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.getEntity() instanceof EntityPlayerSP && event.getWorld() instanceof WorldClient && FMLClientHandler.instance().getClientPlayerEntity() != null && HPRecipes.ERRORS.size() > 0) {
            HPRecipes.ERRORS.forEach(s -> FMLClientHandler.instance().getClientPlayerEntity().func_145747_a(new TextComponentString(TextFormatting.RED + s).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, Loader.instance().getConfigDir() + "/horsepower.cfg")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Changed in in-game config or click to open the config file to fix this"))))));
            HPRecipes.ERRORS.clear();
        }
    }

    @SubscribeEvent
    public static void onServerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncServerRecipesMessage(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onServerLeave(WorldEvent.Unload event) {
        NetworkManager manager;
        if (FMLCommonHandler.instance().getSide().isClient() && (manager = FMLClientHandler.instance().getClientToServerNetworkManager()) != null && !manager.func_150731_c() && HPRecipes.serverSyncedRecipes) {
            HPRecipes.serverSyncedRecipes = false;
            HPRecipes.instance().reloadRecipes();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public static void onToolTip(ItemTooltipEvent event) {
        String part = "";
        if (Configs.misc.showOreDictionaries) {
            StringBuilder out = null;
            for (int id : OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                String s = OreDictionary.getOreName((int)id);
                if (out == null) {
                    out = new StringBuilder((Object)((Object)Colors.LIGHTGRAY) + "Ores: " + (Object)((Object)Colors.ORANGE) + s);
                    continue;
                }
                out.append(", ").append(s);
            }
            if (out != null) {
                event.getToolTip().add(out.toString());
                part = "OreDict";
            }
        }
        if (Configs.misc.showHarvestLevel) {
            boolean added = false;
            for (String harv : Configs.misc.harvestTypes) {
                int harvestLevel = event.getItemStack().func_77973_b().getHarvestLevel(event.getItemStack(), harv, null, null);
                if (harvestLevel <= -1) continue;
                event.getToolTip().add((Object)((Object)Colors.LIGHTGRAY) + "HarvestLevel: " + (Object)((Object)Colors.ORANGE) + StringUtils.capitalize((String)harv) + " (" + harvestLevel + ")");
                if (added) continue;
                part = part + (!part.isEmpty() ? " and " : "") + "HarvestLevel";
                added = true;
            }
        }
        if (!part.isEmpty()) {
            event.getToolTip().add((Object)((Object)Colors.LIGHTGRAY) + "The " + part + " tooltip was added by HorsePower, to disabled check the config.");
        }
    }
}

