/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;

public class ChoppingRecipe
extends ShapedOreRecipe {
    public final List<ItemStack> outputBlocks;

    public ChoppingRecipe(ResourceLocation location, List<ItemStack> variantItems, ItemStack result, Object ... recipe) {
        super(location, result, recipe);
        this.outputBlocks = variantItems;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull InventoryCrafting craftMatrix) {
        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
            for (ItemStack ore : this.outputBlocks) {
                ItemStack stack;
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)(stack = craftMatrix.getStackInSlot(i)), (boolean)false) || Block.getBlockFromItem((Item)stack.getItem()) == Blocks.AIR) continue;
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.getSimpleRecipeOutput().getItem());
                if (!Configs.general.useDynamicCrafting) {
                    if ("minecraft".equals(ore.getItem().getRegistryName().getResourceDomain())) {
                        return BlockChopper.createItemStack(block, Block.getBlockFromItem((Item)stack.getItem()), stack.getItemDamage());
                    }
                    return BlockChopper.createItemStack(block, Blocks.LOG, 0);
                }
                return BlockChopper.createItemStack(block, Block.getBlockFromItem((Item)stack.getItem()), stack.getItemDamage());
            }
        }
        return super.getCraftingResult(craftMatrix);
    }

    @Nonnull
    public ItemStack getRecipeOutput() {
        if (!this.outputBlocks.isEmpty() && !this.output.isEmpty()) {
            ItemStack stack = this.outputBlocks.get(0);
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.output.getItem());
            int meta = stack.getMetadata();
            if (meta == Short.MAX_VALUE) {
                meta = 0;
            }
            return BlockChopper.createItemStack(block, Block.getBlockFromItem((Item)stack.getItem()), meta);
        }
        return super.getRecipeOutput();
    }

    public ItemStack getSimpleRecipeOutput() {
        return this.output;
    }
}

