/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.client.model.modelvariants.PressModels;
import se.gory_moon.horsepower.client.renderer.TileEntityHPBaseRenderer;
import se.gory_moon.horsepower.tileentity.TileEntityPress;

public class TileEntityPressRender
extends TileEntityHPBaseRenderer<TileEntityPress> {
    public void renderTileEntityAt(TileEntityPress te, double x, double y, double z, float partialTicks, int destroyStage) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer buffer = tessellator.getBuffer();
        BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBlockState blockState = te.getWorld().getBlockState(te.getPos());
        if (!(blockState.getBlock() instanceof BlockHPBase)) {
            return;
        }
        IBlockState topState = blockState.withProperty(BlockPress.PART, (Comparable)((Object)PressModels.TOP));
        if (!(topState.getBlock() instanceof BlockHPBase)) {
            return;
        }
        IBakedModel pressModel = dispatcher.getBlockModelShapes().getModelForState(topState);
        this.preDestroyRender(destroyStage);
        this.setRenderSettings();
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        buffer.setTranslation((double)(-te.getPos().getX()), (double)(-te.getPos().getY()), (double)(-te.getPos().getZ()));
        if (destroyStage >= 0) {
            buffer.noColor();
            this.renderBlockDamage(topState, te.getPos(), TileEntityPressRender.getDestroyBlockIcon(destroyStage), (IBlockAccess)te.getWorld());
        } else {
            dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), pressModel, blockState, te.getPos(), buffer, false);
        }
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        float move = (float)te.getField(0) / (float)(Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress : 1);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.translate((double)0.0, (double)(-(0.58 * (double)move)), (double)0.0);
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.draw();
        GlStateManager.popMatrix();
        buffer.setTranslation(0.0, 0.0, 0.0);
        this.postDestroyRender(destroyStage);
        RenderHelper.enableStandardItemLighting();
        if (!(blockState.getBlock() instanceof BlockHPBase)) {
            return;
        }
        if (te.hasWorker()) {
            this.renderLeash(te.getWorker(), x, y, z, 0.0, 0.4, 0.0, partialTicks, te.getPos());
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        if (!te.getStackInSlot(0).isEmpty() && (double)move <= 0.25) {
            this.renderItem(te, te.getStackInSlot(0), 0.5f, 0.5f, 0.5f, 1.0f);
            this.drawString(te, String.valueOf(te.getStackInSlot(0).getCount()), 0.0, 0.35, 0.0);
        }
        if (!te.getStackInSlot(1).isEmpty() && (double)move <= 0.25) {
            this.renderItem(te, te.getStackInSlot(1), 0.5f, 0.5f, 0.5f, 1.0f);
            this.drawString(te, String.valueOf(te.getStackInSlot(1).getCount()), 0.0, 0.35, 0.0);
        }
        GlStateManager.popMatrix();
        super.renderTileEntityAt((TileEntity)te, x, y + 1.0, z, partialTicks, destroyStage);
    }
}

