/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.jei.ChoppingBlockCraftingWrapper;
import se.gory_moon.horsepower.jei.IJeiPlugin;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeMaker;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeWrapper;
import se.gory_moon.horsepower.jei.chopping.HorsePowerChoppingCategory;
import se.gory_moon.horsepower.jei.grinding.GrindingRecipeMaker;
import se.gory_moon.horsepower.jei.grinding.GrindstoneRecipeWrapper;
import se.gory_moon.horsepower.jei.grinding.HorsePowerGrindingCategory;
import se.gory_moon.horsepower.jei.press.HorsePowerPressCategory;
import se.gory_moon.horsepower.jei.press.PressRecipeMaker;
import se.gory_moon.horsepower.jei.press.PressRecipeWrapper;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.ChoppingRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HandGrindstoneRecipe;
import se.gory_moon.horsepower.recipes.PressRecipe;

@JEIPlugin
public class HorsePowerPlugin
implements IModPlugin,
IJeiPlugin {
    public static final String HAND_GRINDING = "horsepower.hand_grinding";
    public static final String GRINDING = "horsepower.grinding";
    public static final String MANUAL_CHOPPING = "horsepower.manual_chopping";
    public static final String CHOPPING = "horsepower.chopping";
    public static final String PRESS = "horsepower.press";
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    private static IJeiRuntime jeiRuntime;
    public static IRecipeRegistry recipeRegistry;
    public static ICraftingGridHelper craftingGridHelper;

    public void register(IModRegistry registry) {
        HorsePowerMod.jeiPlugin = this;
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.handleRecipes(HandGrindstoneRecipe.class, GrindstoneRecipeWrapper::new, HAND_GRINDING);
            registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, true), HAND_GRINDING);
        }
        if (Configs.general.enableHandChoppingBlock && Configs.recipes.useSeperateChoppingRecipes) {
            registry.handleRecipes(ChoppingBlockRecipe.class, ChoppingRecipeWrapper::new, MANUAL_CHOPPING);
            registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true), MANUAL_CHOPPING);
        }
        registry.handleRecipes(GrindstoneRecipe.class, GrindstoneRecipeWrapper::new, GRINDING);
        registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, false), GRINDING);
        registry.handleRecipes(ChoppingBlockRecipe.class, ChoppingRecipeWrapper::new, CHOPPING);
        registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, false), CHOPPING);
        registry.handleRecipes(PressRecipe.class, PressRecipeWrapper::new, PRESS);
        registry.addRecipes(PressRecipeMaker.getPressRecipes(jeiHelpers), PRESS);
        registry.handleRecipes(ChoppingRecipe.class, ChoppingBlockCraftingWrapper::new, "minecraft.crafting");
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{HAND_GRINDING});
        } else {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{GRINDING});
        }
        if (Configs.general.enableHandChoppingBlock) {
            if (Configs.recipes.useSeperateChoppingRecipes) {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_MANUAL_CHOPPER), new String[]{MANUAL_CHOPPING});
            } else {
                registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_MANUAL_CHOPPER), new String[]{CHOPPING});
            }
        }
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), new String[]{GRINDING});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_CHOPPER), new String[]{CHOPPING});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_PRESS), new String[]{PRESS});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), ItemStack.class, new String[]{"info.horsepower:grindstone.info1", "info.horsepower:grindstone.info2", "info.horsepower:grindstone.info3"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        HorsePowerPlugin.jeiRuntime = jeiRuntime;
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModBlocks.BLOCK_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (itemStack.func_77960_j() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModBlocks.BLOCK_MANUAL_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (itemStack.func_77960_j() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), true)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        if (Configs.general.enableHandChoppingBlock && Configs.recipes.useSeperateChoppingRecipes) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerChoppingCategory(registry.getJeiHelpers().getGuiHelper(), true)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerChoppingCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerPressCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    @Override
    public void removeRecipe() {
        if (Configs.recipes.useSeperateChoppingRecipes) {
            for (GrindstoneRecipeWrapper grindstoneRecipeWrapper : GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, true)) {
                jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)grindstoneRecipeWrapper, HAND_GRINDING);
            }
        }
        for (GrindstoneRecipeWrapper grindstoneRecipeWrapper : GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, false)) {
            jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)grindstoneRecipeWrapper, GRINDING);
        }
        if (Configs.recipes.useSeperateChoppingRecipes && Configs.general.enableHandChoppingBlock) {
            for (ChoppingRecipeWrapper choppingRecipeWrapper : ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true)) {
                jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)choppingRecipeWrapper, MANUAL_CHOPPING);
            }
        }
        for (ChoppingRecipeWrapper choppingRecipeWrapper : ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, false)) {
            jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)choppingRecipeWrapper, CHOPPING);
        }
        for (PressRecipeWrapper pressRecipeWrapper : PressRecipeMaker.getPressRecipes(jeiHelpers)) {
            jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)pressRecipeWrapper, PRESS);
        }
    }

    @Override
    public void addRecipes() {
        if (Configs.recipes.useSeperateChoppingRecipes) {
            for (GrindstoneRecipeWrapper grindstoneRecipeWrapper : GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, true)) {
                jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)grindstoneRecipeWrapper, HAND_GRINDING);
            }
        }
        for (GrindstoneRecipeWrapper grindstoneRecipeWrapper : GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, false)) {
            jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)grindstoneRecipeWrapper, GRINDING);
        }
        if (Configs.recipes.useSeperateChoppingRecipes && Configs.general.enableHandChoppingBlock) {
            for (ChoppingRecipeWrapper choppingRecipeWrapper : ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true)) {
                jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)choppingRecipeWrapper, MANUAL_CHOPPING);
            }
        }
        for (ChoppingRecipeWrapper choppingRecipeWrapper : ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, false)) {
            jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)choppingRecipeWrapper, CHOPPING);
        }
        for (PressRecipeWrapper pressRecipeWrapper : PressRecipeMaker.getPressRecipes(jeiHelpers)) {
            jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)pressRecipeWrapper, PRESS);
        }
    }
}

