/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.items;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.recipes.ChoppingRecipe;

@GameRegistry.ObjectHolder(value="horsepower")
public class ModItems {
    public static final Item FLOUR = ((Item)new Item().setRegistryName("flour")).func_77655_b("flour").func_77637_a((CreativeTabs)HorsePowerMod.creativeTab);
    public static final Item DOUGH = ((Item)new Item().setRegistryName("dough")).func_77655_b("dough").func_77637_a((CreativeTabs)HorsePowerMod.creativeTab);

    public static void registerRecipes() {
        if (Configs.general.enableDough) {
            if (Configs.general.enableFlour) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(DOUGH), (Object[])new Object[]{FLOUR, Items.field_151131_as});
            }
            GameRegistry.addSmelting((Item)DOUGH, (ItemStack)new ItemStack(Items.field_151025_P), (float)0.0f);
            OreDictionary.registerOre((String)"foodDough", (Item)DOUGH);
        }
        if (Configs.general.enableFlour) {
            OreDictionary.registerOre((String)"foodFlour", (Item)FLOUR);
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_GRINDSTONE, new Object[]{"LSL", "###", "###", Character.valueOf('S'), "stickWood", Character.valueOf('#'), "stone", Character.valueOf('L'), Items.field_151058_ca}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_HAND_GRINDSTONE, new Object[]{"  S", "###", "###", Character.valueOf('S'), "stickWood", Character.valueOf('#'), "stone"}));
        GameRegistry.addRecipe((IRecipe)new ChoppingRecipe((List<ItemStack>)OreDictionary.getOres((String)"logWood"), ModBlocks.BLOCK_CHOPPER, "LSL", "SFS", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('L'), Items.field_151058_ca, Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('W'), "logWood"));
        if (Configs.general.enableHandChoppingBlock) {
            GameRegistry.addRecipe((IRecipe)new ChoppingRecipe((List<ItemStack>)OreDictionary.getOres((String)"logWood"), ModBlocks.BLOCK_MANUAL_CHOPPER, "W", Character.valueOf('W'), "logWood"));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.BLOCK_PRESS, new Object[]{"LSL", "#P#", "###", Character.valueOf('S'), "stickWood", Character.valueOf('#'), "plankWood", Character.valueOf('L'), Items.field_151058_ca, Character.valueOf('P'), Blocks.field_150452_aw}));
        if (Configs.general.removeVanillaRecipes) {
            ModItems.removeRecipes();
        }
    }

    private static void removeRecipes() {
        Container dummyContainer = new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }

            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "###", Character.valueOf('#'), Items.field_151015_O)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.field_151120_aE)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack(Blocks.field_189880_di))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.field_151103_aS)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.field_185164_cV)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()))));
    }

    private static InventoryCrafting setRecipe(InventoryCrafting crafting, Object ... recipeComponents) {
        crafting.func_174888_l();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = ItemStack.field_190927_a;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            if (!map.containsKey(Character.valueOf(c0))) continue;
            crafting.func_70299_a(l, ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l());
        }
        return crafting;
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (!ItemStack.func_77989_b((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            recipes.remove(scan);
        }
    }

    private static void removeRecipe(IRecipe recipe) {
        ArrayList recipes = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        if (recipe != null) {
            recipes.remove(recipe);
        }
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!irecipe.func_77569_a(craftMatrix, null)) continue;
            return irecipe;
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="horsepower")
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Item[] items = new Item[]{FLOUR, DOUGH};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                if (!Configs.general.enableFlour && item == FLOUR || !Configs.general.enableDough && item == DOUGH) continue;
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }
    }
}

