package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

import java.util.Arrays;

public abstract class TileEntityHPBaseRenderer<T extends TileEntityHPBase> extends TileEntitySpecialRenderer<T> {

    private static TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    protected void renderStillItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        renderItem(te, stack, x, y, z, scale, false);
    }

    protected void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        renderItem(te, stack, x, y, z, scale, true);
    }

    private void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale, boolean rotate) {
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (stack != null) {
            GlStateManager.func_179109_b(x, y, z);
            EntityItem entityitem = new EntityItem(te.func_145831_w(), 0.0D, 0.0D, 0.0D, stack.func_77946_l());
            entityitem.field_70290_d = 0.0F;
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();

            float rotation = (float) (720.0 * (System.currentTimeMillis() & 0x3FFFL) / 0x3FFFL);

            if (rotate)
                GlStateManager.func_179114_b(rotation, 0.0F, 1.0F, 0);
            GlStateManager.func_179152_a(0.5F * scale, 0.5F * scale, 0.5F * scale);
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();

            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public void drawString(TileEntityHPBase te, String str, double x, double y, double z) {
        if (!canShowAmount(te))
            return;
        func_190053_a(true);
        Entity entity = this.field_147501_a.field_147551_g;
        double d0 = te.func_145835_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);

        if (d0 <= (double)(14 * 14)) {
            float f = this.field_147501_a.field_147562_h;
            float f1 = this.field_147501_a.field_147563_i;
            FontRenderer fontRenderer = func_147498_b();
            GlStateManager.func_179094_E();

            GlStateManager.func_179137_b(x, y, z);
            GlStateManager.func_187432_a(0.0F, 1.0F, 0.0F);
            if (te.getForward() == EnumFacing.EAST || te.getForward() == EnumFacing.WEST)
                FacingToRotation.get( te.getForward().func_176734_d()).glRotateCurrentMat();
            else
                FacingToRotation.get( te.getForward()).glRotateCurrentMat();


            GlStateManager.func_179114_b(-f, 0.0F, 1.0F, 0.0F);
            GlStateManager.func_179114_b(f1, 1.0F, 0.0F, 0.0F);
            GlStateManager.func_179152_a(-0.015F, -0.015F, 0.015F);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a(false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();

            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a(true);
            fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, 0, -1);

            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
            GlStateManager.func_179121_F();
        }
        func_190053_a(false);
    }

    public boolean canShowAmount(TileEntityHPBase te) {
        return Configs.client.renderItemAmount && (!Configs.client.mustLookAtBlock || this.field_147501_a.field_190057_j != null && te.func_174877_v().equals(this.field_147501_a.field_190057_j.func_178782_a()));
    }

    protected void renderItemWithFacing(World world, TileEntityHPBase tile, ItemStack stack, double ox, double oy, double oz, float x, float y, float z, float scale) {
        if (stack.func_190926_b())
            return;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(ox, oy, oz);
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        FacingToRotation.get( tile.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );
        renderItem(tile, stack, x, y, z, scale);
        GlStateManager.func_179121_F();

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(ox , oy, oz);
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        FacingToRotation.get( tile.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        drawString(tile, String.valueOf(stack.func_190916_E()), x, y + 0.3,  z);
        GlStateManager.func_179121_F();
    }

    protected void renderBaseModel(TileEntityHPBase te, Tessellator tessellator, VertexBuffer buffer, double x, double y, double z) {
        // Most of this is blatantly copied from FastTESR
        setRenderSettings();

        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a( blockState );

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p() );
        dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), model, blockState, te.func_174877_v(), buffer, false );
        buffer.func_178969_c( 0, 0, 0 );
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected void renderBaseModelWithFacing(TileEntityHPBase te, IBlockState blockState, Tessellator tessellator, VertexBuffer buffer, double x, double y, double z, int destroyStage) {
        // Most of this is blatantly copied from FastTESR
        preDestroyRender(destroyStage);
        setRenderSettings();

        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a( blockState );

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p() );

        if (destroyStage >= 0) {
            buffer.func_78914_f();
            renderBlockDamage(blockState, te.func_174877_v(), getDestroyBlockIcon(destroyStage), te.func_145831_w());
        } else
            dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), model, blockState, te.func_174877_v(), buffer, false );

        buffer.func_178969_c( 0, 0, 0 );
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );

        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        FacingToRotation.get( te.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        tessellator.func_78381_a();
        buffer.func_178969_c(0.0D, 0.0D, 0.0D);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();
    }

    protected void setRenderSettings() {
        this.func_147499_a( TextureMap.field_110575_b );
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b( GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA );
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();

        if( Minecraft.func_71379_u() )
        {
            GlStateManager.func_179103_j( GL11.GL_SMOOTH );
        }
        else
        {
            GlStateManager.func_179103_j( GL11.GL_FLAT );
        }
    }

    protected void preDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);

            GlStateManager.func_187428_a(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 0.5F);
            GlStateManager.func_179136_a(-3.0F, -3.0F);
            GlStateManager.func_179088_q();
            GlStateManager.func_179092_a(516, 0.1F);
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
        }
    }

    protected void postDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {

            GlStateManager.func_179118_c();
            GlStateManager.func_179136_a(0.0F, 0.0F);
            GlStateManager.func_179113_r();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a(true);
            GlStateManager.func_179121_F();

            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            GlStateManager.func_179084_k();
        }
    }

    /**
     * Gets the value between start and end according to pct
     */
    private double interpolateValue(double start, double end, double pct)
    {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityCreature entity, double ox, double oy, double oz, double x, double y, double z, float partialTicks, BlockPos pos) {
        if (entity != null) {
            oy = oy - 0.7D;
            double d2 = 0.0D;
            double d3 = 0.0D;
            double d4 = -1.0D;

            double d9 = this.interpolateValue(entity.field_70760_ar, entity.field_70761_aq, (double)partialTicks) * 0.01745329238474369D + (Math.PI / 2D);
            d2 = Math.cos(d9) * (double)entity.field_70130_N * 0.4D;
            d3 = Math.sin(d9) * (double)entity.field_70130_N * 0.4D;
            double d6 = (this.interpolateValue(entity.field_70169_q, entity.field_70165_t, (double)partialTicks)) + d2;
            double d7 = this.interpolateValue(entity.field_70167_r + entity.func_70047_e() * 1.1D, entity.field_70163_u + entity.func_70047_e() * 1.1D, (double)partialTicks) - d4 * 0.5D - 0.25D - y;
            double d8 = (this.interpolateValue(entity.field_70166_s, entity.field_70161_v, (double)partialTicks)) + d3;

            d2 = 0.5D;
            d3 = 0.5D;
            double d10 = pos.func_177958_n() + d2;
            double d11 = pos.func_177956_o();
            double d12 = pos.func_177952_p() + d3;
            ox += d2 + x;
            oz += d3 + z;
            oy += y;

            renderLeach(d6, d7, d8, ox, oy, oz, d10, d11, d12);
        }
    }

    protected void renderLeach(double x1, double y1, double z1, double ox, double oy, double oz, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();

        double d13 = (double)((float)(x1 - x2));
        double d14 = (double)((float)(y1 - y2));
        double d15 = (double)((float)(z1 - z2));

        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();

        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);

        for (int j = 0; j <= 24; ++j)
        {
            float f = 0.5F;
            float f1 = 0.4F;
            float f2 = 0.3F;

            if (j % 2 == 0)
            {
                f *= 0.7F;
                f1 *= 0.7F;
                f2 *= 0.7F;
            }

            float f3 = (float)j / 24.0F;
            vertexbuffer.func_181662_b(ox + d13 * (double)f3 + 0.0D, oy + d14 * (double)(f3 * f3 + f3) * 0.5D + (double)((24.0F - (float)j) / 18.0F + 0.125F), oz + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0F).func_181675_d();
            vertexbuffer.func_181662_b(ox + d13 * (double)f3 + 0.025D, oy + d14 * (double)(f3 * f3 + f3) * 0.5D + (double)((24.0F - (float)j) / 18.0F + 0.125F) + 0.025D, oz + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0F).func_181675_d();
        }

        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);

        for (int k = 0; k <= 24; ++k)
        {
            float f4 = 0.5F;
            float f5 = 0.4F;
            float f6 = 0.3F;

            if (k % 2 == 0)
            {
                f4 *= 0.7F;
                f5 *= 0.7F;
                f6 *= 0.7F;
            }

            float f7 = (float)k / 24.0F;
            vertexbuffer.func_181662_b(ox + d13 * (double)f7 + 0.0D, oy + d14 * (double)(f7 * f7 + f7) * 0.5D + (double)((24.0F - (float)k) / 18.0F + 0.125F) + 0.025D, oz + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0F).func_181675_d();
            vertexbuffer.func_181662_b(ox + d13 * (double)f7 + 0.025D, oy + d14 * (double)(f7 * f7 + f7) * 0.5D + (double)((24.0F - (float)k) / 18.0F + 0.125F), oz + d15 * (double)f7 + 0.025D).func_181666_a(f4, f5, f6, 1.0F).func_181675_d();
        }

        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess)
    {
        state = state.func_185899_b(blockAccess, pos);
        IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        IBakedModel ibakedmodel1 = net.minecraftforge.client.ForgeHooksClient.getDamageModel(ibakedmodel, texture, state, blockAccess, pos);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a(blockAccess, ibakedmodel1, state, pos, Tessellator.func_178181_a().func_178180_c(), true);
    }

    public static TextureAtlasSprite getDestroyBlockIcon(int destroyState) {
        if (destroyBlockIcons[destroyState] == null) {
            destroyBlockIcons = ObfuscationReflectionHelper.getPrivateValue(RenderGlobal.class, Minecraft.func_71410_x().field_71438_f, "destroyBlockIcons", "field_94141_F");
        }
        return destroyBlockIcons[destroyState];
    }

    public static void clearDestroyStageicons() {
        Arrays.stream(destroyBlockIcons).forEach(textureAtlasSprite -> textureAtlasSprite = null);
    }

}
