/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.property.PropertyUnlistedString;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Utils;

public abstract class BlockHPChoppingBase
extends BlockHPBase {
    public static final PropertyUnlistedString SIDE_TEXTURE = new PropertyUnlistedString("side_texture");
    public static final PropertyUnlistedString TOP_TEXTURE = new PropertyUnlistedString("top_texture");

    public BlockHPChoppingBase() {
        super(Material.WOOD);
        this.setHarvestLevel("axe", 0);
        this.setSoundType(SoundType.WOOD);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        Object tile = this.getTileEntity(world, pos);
        if (tile != null) {
            return BlockHPChoppingBase.getExtendedState(tile, ((TileEntityHPBase)((Object)tile)).getExtendedState(extendedState));
        }
        return super.getExtendedState(state, world, pos);
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TileEntity te = world.getTileEntity(pos);
        if (te != null && (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper)) {
            NBTTagCompound tag = item.hasTagCompound() ? item.getTagCompound() : new NBTTagCompound();
            NBTTagCompound data = te.getTileData().getCompoundTag("textureBlock");
            if (!data.hasNoTags()) {
                tag.setTag("textureBlock", (NBTBase)data);
            }
            if (!tag.hasNoTags()) {
                item.setTagCompound(tag);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.getItemDropped(state, world.rand, 0);
        if (item != Items.AIR) {
            drops.add(new ItemStack(item, 1, this.damageDropped(state)));
        }
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.isRemote && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.getItem() != Item.getItemFromBlock((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            for (ItemStack item : items) {
                if (!(worldIn.rand.nextFloat() <= chance)) continue;
                BlockHPChoppingBase.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag = stack.hasTagCompound() ? stack.getTagCompound() : new NBTTagCompound();
        Object tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        NBTTagCompound baseTag = tag != null ? tag.getCompoundTag("textureBlock") : new NBTTagCompound();
        tile.getTileData().setTag("textureBlock", (NBTBase)baseTag);
    }

    public static ItemStack createItemStack(BlockHPChoppingBase table, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.writeToNBT(subTag);
            tag.setTag("textureBlock", (NBTBase)subTag);
            stack.setTagCompound(tag);
        }
        return stack;
    }

    public void getSubBlocks(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)"logWood")) {
            if (!Configs.general.useDynamicDisplay && !"minecraft".equals(stack.getItem().getRegistryName().getResourceDomain())) continue;
            Block block = BlockHPChoppingBase.getBlockFromItem((Item)stack.getItem());
            int blockMeta = stack.getItemDamage();
            if (blockMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.create();
                block.getSubBlocks(stack.getItem(), null, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add((Object)BlockHPChoppingBase.createItemStack(this, BlockHPChoppingBase.getBlockFromItem((Item)subBlock.getItem()), subBlock.getItemDamage()));
                }
                continue;
            }
            list.add((Object)BlockHPChoppingBase.createItemStack(this, block, blockMeta));
        }
    }

    public static IExtendedBlockState getExtendedState(TileEntityHPBase te, IExtendedBlockState state) {
        ItemStack stack;
        String side_texture = te.getTileData().getString("side_texture");
        String top_texture = te.getTileData().getString("top_texture");
        if ((side_texture.isEmpty() || top_texture.isEmpty()) && !(stack = new ItemStack(te.getTileData().getCompoundTag("textureBlock"))).isEmpty()) {
            Block block = Block.getBlockFromItem((Item)stack.getItem());
            IBlockState state1 = block.getStateFromMeta(stack.getMetadata());
            side_texture = Utils.getTextureFromBlockstate(state1).getIconName();
            top_texture = Utils.getTopTextureFromBlockstate(state1).getIconName();
            te.getTileData().setString("side_texture", side_texture);
        }
        if (!side_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)SIDE_TEXTURE, (Object)side_texture);
        }
        if (!top_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)TOP_TEXTURE, (Object)top_texture);
        }
        return state;
    }
}

