/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityManualChopper
extends TileEntityHPBase {
    private int currentItemChopAmount;
    private int totalItemChopAmount;
    private IItemHandler handlerSide = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);

    public TileEntityManualChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("chopTime", this.currentItemChopAmount);
        compound.func_74768_a("totalChopTime", this.totalItemChopAmount);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.getStackInSlot(0).func_190916_E() > 0) {
            this.currentItemChopAmount = compound.func_74762_e("chopTime");
            this.totalItemChopAmount = compound.func_74762_e("totalChopTime");
        } else {
            this.currentItemChopAmount = 0;
            this.totalItemChopAmount = 1;
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack, true) && this.getStackInSlot(1).func_190926_b() && this.getStackInSlot(0).func_190926_b();
    }

    public boolean chop(EntityPlayer player) {
        if (this.canWork()) {
            ++this.currentItemChopAmount;
            if (this.currentItemChopAmount >= this.totalItemChopAmount) {
                this.currentItemChopAmount = 0;
                this.totalItemChopAmount = HPRecipes.instance().getChoppingTime(this.getStackInSlot(0), true);
                this.chopItem(player);
                return true;
            }
            this.func_70296_d();
        }
        return false;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.getStackInSlot(1).func_190926_b()) {
            this.func_70296_d();
        }
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemChopAmount = HPRecipes.instance().getChoppingTime(stack, true);
            this.currentItemChopAmount = 0;
            this.func_70296_d();
        }
    }

    private void chopItem(EntityPlayer player) {
        if (this.canWork()) {
            ItemStack input = this.getStackInSlot(0);
            if (!this.func_145831_w().field_72995_K) {
                ItemStack result = this.getRecipeItemStack();
                ItemStack output = this.getStackInSlot(1);
                if (Configs.general.choppingBlockDrop) {
                    InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)this.func_174877_v().func_177952_p(), (ItemStack)result.func_77946_l());
                } else if (output.func_190926_b()) {
                    this.setInventorySlotContents(1, result.func_77946_l());
                } else if (output.func_77973_b() == result.func_77973_b()) {
                    output.func_190917_f(result.func_190916_E());
                }
            }
            this.func_145831_w().func_184133_a(player, this.func_174877_v(), SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            input.func_190918_g(1);
            this.func_70296_d();
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.getStackInSlot(0), true);
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getChoppingBlockRecipe(this.getStackInSlot(0), true);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopAmount;
            }
            case 1: {
                return this.currentItemChopAmount;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopAmount = value;
                break;
            }
            case 1: {
                this.currentItemChopAmount = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "container.manual_chopper";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap = super.getCapability(capability, facing);
        return (T)(cap != null ? cap : (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.handlerSide : null));
    }
}

