/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.tileentity.IHPInventory;

public abstract class TileEntityHPBase
extends TileEntity {
    protected NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    protected IHPInventory inventory;
    private EnumFacing forward = null;
    private IItemHandler handlerTop = null;
    private IItemHandler handlerBottom = null;

    public TileEntityHPBase(int inventorySize) {
        this.itemStacks = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.inventory = new IHPInventory(){

            public int func_70302_i_() {
                return TileEntityHPBase.this.itemStacks.size();
            }

            public boolean func_191420_l() {
                for (ItemStack itemstack : TileEntityHPBase.this.itemStacks) {
                    if (itemstack.func_190926_b()) continue;
                    return false;
                }
                return true;
            }

            public ItemStack func_70301_a(int index) {
                if (index >= TileEntityHPBase.this.itemStacks.size()) {
                    return ItemStack.field_190927_a;
                }
                return (ItemStack)TileEntityHPBase.this.itemStacks.get(index);
            }

            public ItemStack func_70298_a(int index, int count) {
                ItemStack stack = ItemStackHelper.func_188382_a(TileEntityHPBase.this.itemStacks, (int)index, (int)count);
                if (!stack.func_190926_b()) {
                    this.func_70296_d();
                }
                return stack;
            }

            public ItemStack func_70304_b(int index) {
                ItemStack stack = ItemStackHelper.func_188383_a(TileEntityHPBase.this.itemStacks, (int)index);
                return stack;
            }

            public void func_70299_a(int index, ItemStack stack) {
                TileEntityHPBase.this.setInventorySlotContents(index, stack);
            }

            @Override
            public void setSlotContent(int index, ItemStack stack) {
                TileEntityHPBase.this.itemStacks.set(index, (Object)stack);
                if (index == 0 && stack.func_190916_E() > this.func_70297_j_()) {
                    stack.func_190920_e(this.func_70297_j_());
                }
            }

            public int func_70297_j_() {
                return TileEntityHPBase.this.getInventoryStackLimit();
            }

            public void func_70296_d() {
                TileEntityHPBase.this.func_70296_d();
            }

            public boolean func_70300_a(EntityPlayer player) {
                return TileEntityHPBase.this.func_145831_w().func_175625_s(TileEntityHPBase.this.func_174877_v()) == TileEntityHPBase.this && player.func_70092_e((double)TileEntityHPBase.this.func_174877_v().func_177958_n() + 0.5, (double)TileEntityHPBase.this.func_174877_v().func_177956_o() + 0.5, (double)TileEntityHPBase.this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
            }

            public void func_174889_b(EntityPlayer player) {
            }

            public void func_174886_c(EntityPlayer player) {
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return TileEntityHPBase.this.isItemValidForSlot(index, stack);
            }

            public int func_174887_a_(int id) {
                return TileEntityHPBase.this.getField(id);
            }

            public void func_174885_b(int id, int value) {
                TileEntityHPBase.this.setField(id, value);
            }

            public int func_174890_g() {
                return TileEntityHPBase.this.getFieldCount();
            }

            public void func_174888_l() {
                TileEntityHPBase.this.itemStacks.clear();
            }

            public String func_70005_c_() {
                return TileEntityHPBase.this.getName();
            }

            public boolean func_145818_k_() {
                return false;
            }

            public ITextComponent func_145748_c_() {
                return TileEntityHPBase.this.func_145748_c_();
            }
        };
        this.handlerTop = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);
        this.handlerBottom = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 1, this.getOutputSlot() + 1);
    }

    public abstract HPRecipeBase getRecipe();

    public abstract ItemStack getRecipeItemStack();

    public abstract int getInventoryStackLimit();

    public abstract boolean isItemValidForSlot(int var1, ItemStack var2);

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public abstract String getName();

    public abstract int getOutputSlot();

    public ItemStack getStackInSlot(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack removeStackFromSlot(int index) {
        return this.inventory.func_70304_b(index);
    }

    public IHPInventory getInventory() {
        return this.inventory;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventory.setSlotContent(index, stack);
    }

    public int getInventoryStackLimit(ItemStack stack) {
        return this.getInventoryStackLimit();
    }

    public IExtendedBlockState getExtendedState(IExtendedBlockState state) {
        return state;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemStacks = NonNullList.func_191197_a((int)this.inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            this.forward = EnumFacing.func_176739_a((String)compound.func_74779_i("forward"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemStacks);
        if (this.canBeRotated()) {
            compound.func_74778_a("forward", this.getForward().func_176610_l());
        }
        return compound;
    }

    public void func_70296_d() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
        super.func_70296_d();
    }

    public boolean canWork() {
        ItemStack outputSecondary;
        if (this.inventory.func_70301_a(0).func_190926_b()) {
            return false;
        }
        HPRecipeBase recipeBase = this.getRecipe();
        if (recipeBase == null) {
            return false;
        }
        ItemStack itemstack = recipeBase.getOutput();
        ItemStack secondary = recipeBase.getSecondary();
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.inventory.func_70301_a(1);
        ItemStack itemStack = outputSecondary = secondary.func_190926_b() ? ItemStack.field_190927_a : this.inventory.func_70301_a(2);
        if (!secondary.func_190926_b() && !outputSecondary.func_190926_b()) {
            if (!outputSecondary.func_77969_a(secondary)) {
                return false;
            }
            if (outputSecondary.func_190916_E() + secondary.func_190916_E() > secondary.func_77976_d()) {
                return false;
            }
        }
        return output.func_190926_b() || output.func_77969_a(itemstack) && output.func_190916_E() + itemstack.func_190916_E() <= output.func_77976_d();
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        if (this.forward == null) {
            return EnumFacing.NORTH;
        }
        return this.forward;
    }

    public void setForward(EnumFacing forward) {
        this.forward = forward;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

