/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.property.PropertyUnlistedString;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Utils;

public abstract class BlockHPChoppingBase
extends BlockHPBase {
    public static final PropertyUnlistedString SIDE_TEXTURE = new PropertyUnlistedString("side_texture");
    public static final PropertyUnlistedString TOP_TEXTURE = new PropertyUnlistedString("top_texture");

    public BlockHPChoppingBase() {
        super(Material.field_151575_d);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        Object tile = this.getTileEntity(world, pos);
        if (tile != null) {
            return BlockHPChoppingBase.getExtendedState(tile, ((TileEntityHPBase)((Object)tile)).getExtendedState(extendedState));
        }
        return super.getExtendedState(state, world, pos);
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper)) {
            NBTTagCompound tag = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
            NBTTagCompound data = te.getTileData().func_74775_l("textureBlock");
            if (!data.func_82582_d()) {
                tag.func_74782_a("textureBlock", (NBTBase)data);
            }
            if (!tag.func_82582_d()) {
                item.func_77982_d(tag);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_180660_a(state, world.field_73012_v, 0);
        if (item != Items.field_190931_a) {
            drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockHPChoppingBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        Object tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        NBTTagCompound baseTag = tag != null ? tag.func_74775_l("textureBlock") : new NBTTagCompound();
        tile.getTileData().func_74782_a("textureBlock", (NBTBase)baseTag);
    }

    public static ItemStack createItemStack(BlockHPChoppingBase table, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.func_77955_b(subTag);
            tag.func_74782_a("textureBlock", (NBTBase)subTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)"logWood")) {
            Block block = BlockHPChoppingBase.func_149634_a((Item)stack.func_77973_b());
            int blockMeta = stack.func_77952_i();
            if (blockMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.func_191196_a();
                block.func_149666_a(stack.func_77973_b(), null, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add((Object)BlockHPChoppingBase.createItemStack(this, BlockHPChoppingBase.func_149634_a((Item)subBlock.func_77973_b()), subBlock.func_77952_i()));
                }
                continue;
            }
            list.add((Object)BlockHPChoppingBase.createItemStack(this, block, blockMeta));
        }
    }

    public static IExtendedBlockState getExtendedState(TileEntityHPBase te, IExtendedBlockState state) {
        ItemStack stack;
        String side_texture = te.getTileData().func_74779_i("side_texture");
        String top_texture = te.getTileData().func_74779_i("top_texture");
        if ((side_texture.isEmpty() || top_texture.isEmpty()) && !(stack = new ItemStack(te.getTileData().func_74775_l("textureBlock"))).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state1 = block.func_176203_a(stack.func_77960_j());
            side_texture = Utils.getTextureFromBlockstate(state1).func_94215_i();
            top_texture = Utils.getTopTextureFromBlockstate(state1).func_94215_i();
            te.getTileData().func_74778_a("side_texture", side_texture);
        }
        if (!side_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)SIDE_TEXTURE, (Object)side_texture);
        }
        if (!top_texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)TOP_TEXTURE, (Object)top_texture);
        }
        return state;
    }
}

