package se.gory_moon.horsepower.blocks;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.client.renderer.modelvariants.HandGrindstoneModels;
import se.gory_moon.horsepower.lib.Constants;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

import javax.annotation.Nullable;
import java.util.List;

@Optional.Interface(iface = "mcjty.theoneprobe.api.IProbeInfoAccessor", modid = "theoneprobe")
public class BlockHandGrindstone extends BlockHPBase implements IProbeInfoAccessor {

    public static final UnlistedDirection FACING = new UnlistedDirection("facing");
    public static final PropertyEnum<HandGrindstoneModels> PART = PropertyEnum.func_177709_a("part", HandGrindstoneModels.class);

    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(1D/16D, 0.0D, 1D/16D, 15D/16D, 10D/16D, 15D/16D);
    private static final AxisAlignedBB BOUNDING_AABB = new AxisAlignedBB(1D/16D, 0.0D, 1D/16D, 15D/16D, 14D/16D, 15D/16D);

    public BlockHandGrindstone() {
        super(Material.field_151576_e);
        func_149711_c(1.5F);
        func_149752_b(10F);
        setHarvestLevel("pickaxe", 1);
        func_149672_a(SoundType.field_185851_d);
        setRegistryName(Constants.HAND_GRINDSTONE_BLOCK);
        func_149663_c(Constants.HAND_GRINDSTONE_BLOCK);
        func_149647_a(CreativeTabs.field_78031_c);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Override
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY_AABB;
    }

    @Override
    public int getSlot(IBlockState state, float hitX, float hitY, float hitZ) {
        EnumFacing f = ((IExtendedBlockState)state).getValue(FACING).func_176734_d();
        if (hitX >= 0.3125 && hitX <= 0.6875 && hitY >= 0.52 && hitZ >= 0.625 && hitZ <= 0.9375)
            return f == EnumFacing.NORTH ? 2: f == EnumFacing.SOUTH ? -2: f == EnumFacing.EAST ? 1: 0;
        else if (hitX >= 0.3125 && hitX <= 0.6875 && hitY >= 0.52 && hitZ >= 0.0625 && hitZ <= 0.375)
            return f == EnumFacing.NORTH ? -2: f == EnumFacing.SOUTH ? 2: f == EnumFacing.EAST ? 0: 1;
        else if (hitX >= 0.0625 && hitX <= 0.375 && hitY >= 0.52 && hitZ >= 0.3125 && hitZ <= 0.6875)
            return f == EnumFacing.NORTH ? 0: f == EnumFacing.SOUTH ? 1: f == EnumFacing.EAST ? 2: -2;
        else if (hitX >= 0.625 && hitX <= 0.9375 && hitY >= 0.52 && hitZ >= 0.3125 && hitZ <= 0.6875)
            return f == EnumFacing.NORTH ? 1: f == EnumFacing.SOUTH ? 0: f == EnumFacing.EAST ? -2: 2;

        return -2;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player instanceof FakePlayer || player == null)
            return true;

        TileEntityHPBase tile = getTileEntity(worldIn, pos);
        if (tile instanceof TileEntityHandGrindstone && tile.canWork() && !player.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                ((TileEntityHandGrindstone) tile).turn();
                return true;
            } else
                return true;
        }

        return super.func_180639_a(worldIn, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {

    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityHandGrindstone();
    }

    @Override
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState(this, new IProperty[] {PART}, new IUnlistedProperty[]{FACING});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityHPBase tile = getTileEntity(world, pos);
        if (tile == null)
            return state;

        return ((IExtendedBlockState) state).withProperty(FACING, tile.getForward()).func_177226_a(PART, state.func_177229_b(PART));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, ((IExtendedBlockState)state).withProperty(FACING, placer.func_174811_aO().func_176734_d()).func_177226_a(PART, HandGrindstoneModels.BASE), 2);

        TileEntityHPBase tile = getTileEntity(worldIn, pos);
        if (tile == null)
            return;
        tile.setForward(placer.func_184172_bi().func_176734_d());
    }

    @Override
    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.HAND_GRINDSTONE.INFO.translate("\n" + Colors.LIGHTGRAY.toString()));
    }

    // The One Probe Integration
    @Optional.Method(modid = "theoneprobe")
    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof TileEntityHandGrindstone) {
            TileEntityHandGrindstone te = (TileEntityHandGrindstone) tileEntity;
            probeInfo.progress((long) ((((double)te.getField(1)) / ((double)te.getField(0))) * 100L), 100L, new ProgressStyle().prefix(Localization.TOP.GRINDSTONE_PROGRESS.translate() + " ").suffix("%"));
        }
    }
}
