/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityFiller
extends TileEntity {
    public TileEntityHPBase getFilledTileEntity() {
        BlockPos pos = this.getFilledPos();
        TileEntity tileEntity = this.getWorld().getTileEntity(pos);
        if (tileEntity instanceof TileEntityHPBase) {
            return (TileEntityHPBase)tileEntity;
        }
        return null;
    }

    public BlockPos getFilledPos() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        if (!(state.getBlock() instanceof BlockHPBase)) {
            return this.getPos();
        }
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockDirectional.FACING);
        return this.pos.offset(facing);
    }

    public void markDirty() {
        TileEntityHPBase te = this.getFilledTileEntity();
        if (te != null) {
            te.markDirty();
        }
        super.markDirty();
    }

    public ITextComponent getDisplayName() {
        TileEntityHPBase te = this.getFilledTileEntity();
        if (te != null) {
            return te.getDisplayName();
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntityHPBase te = this.getFilledTileEntity();
        if (te != null) {
            return te.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityHPBase te = this.getFilledTileEntity();
        if (te != null) {
            return te.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

